unit fROR_CDCList;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   $Revision: 40 $  $Modtime: 3/07/07 3:35p $
*       Site:           Hines OIFO
*       Developers:                        @domain.ext
*
*       Description:    CDC form window
*
*       Notes:
*
================================================================================
*       $Archive: /CCR v1.5/Current/fROR_CDCList.pas $
*
* $History: fROR_CDCList.pas $
 * 
 * *****************  Version 40  *****************
 * User: Vhaishgavris Date: 3/08/07    Time: 1:47p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 39  *****************
 * User: Vhaishgavris Date: 6/26/06    Time: 1:49p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 38  *****************
 * User: Vhaishgavris Date: 5/19/06    Time: 3:22p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 37  *****************
 * User: Vhaishgavris Date: 3/13/06    Time: 3:52p
 * Updated in $/CCR v1.5/Current
 * 
 * *****************  Version 36  *****************
 * User: Vhaishgavris Date: 1/20/06    Time: 12:33p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 35  *****************
 * User: Vhaishgavris Date: 12/05/05   Time: 4:17p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 34  *****************
 * User: Vhaishgavris Date: 11/23/05   Time: 3:38p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 33  *****************
 * User: Vhaishgavris Date: 11/22/05   Time: 5:31p
 * Updated in $/CCR v1.0/Current
 * 
 * *****************  Version 32  *****************
 * User: Vhaishgavris Date: 10/14/05   Time: 11:09a
 * Updated in $/CCR v1.0/Current
 *
 * *****************  Version 31  *****************
 * User: Vhaishgavris Date: 3/02/05    Time: 11:53a
 * Updated in $/CCR v1.0/Current
 *
 * *****************  Version 30  *****************
 * User: Vhaishgavris Date: 2/28/05    Time: 3:54p
 * Updated in $/CCR v1.0/Current
 *
*
================================================================================
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ToolWin, ComCtrls, ExtCtrls, StdCtrls, ActnList, Buttons, ImgList,
  uROR_CustomControls, htmlhint, mswheel, ovcbase, ovcef, ovcpb, ovcnf,
  o32editf, o32flxed;

type
  TFormCDC = class(TForm)
    pnlOptions: TPanel;
    Splitter1: TSplitter;
    pnlTree: TPanel;
    pnlTreeHeader: TPanel;
    tvOptions: TTreeView;
    pnlDetails: TPanel;
    pnlDetailsHeader: TPanel;
    ActionList1: TActionList;
    acShowHide: TAction;
    pcCDC: TPageControl;
    tsForm: TTabSheet;
    sbCDC21: TScrollBox;
    pnlCDC21_Title: TPanel;
    Panel15: TPanel;
    Panel34: TPanel;
    Panel1: TPanel;
    pnlCDC21_I: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Panel3: TPanel;
    Panel33: TPanel;
    edt1_1: TEdit;
    edt1_3: TEdit;
    edt1_4: TEdit;
    edt1_5: TEdit;
    edt1_6: TEdit;
    cmbb1_1: TComboBox;
    edt1_2: TEdit;
    pnlCDC21_II: TPanel;
    Label14: TLabel;
    Label15: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label16: TLabel;
    Label18: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Panel23: TPanel;
    Panel27: TPanel;
    dtp2_1: TDateTimePicker;
    edt2_1: TEdit;
    edt2_2: TEdit;
    edt2_3: TEdit;
    edt2_4: TEdit;
    edt2_5: TEdit;
    edt2_6: TEdit;
    pnlCDC21_III: TPanel;
    Panel26: TPanel;
    pnlCDC21_IV: TPanel;
    Panel29: TPanel;
    Panel30: TPanel;
    pnlCDC21_V: TPanel;
    Label43: TLabel;
    Panel32: TPanel;
    Panel35: TPanel;
    Panel42: TPanel;
    pnlCDC21_VII: TPanel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Panel4: TPanel;
    edt7_1: TEdit;
    edt7_5: TEdit;
    edt7_3: TEdit;
    edt7_6: TEdit;
    edt7_4: TEdit;
    edt7_2: TEdit;
    pnlCDC21_VIII: TPanel;
    Label80: TLabel;
    Label81: TLabel;
    Label95: TLabel;
    Panel28: TPanel;
    Panel31: TPanel;
    pnlCDC21_IX: TPanel;
    Label136: TLabel;
    Label139: TLabel;
    Label142: TLabel;
    Label143: TLabel;
    Panel39: TPanel;
    Panel40: TPanel;
    pnlCDC21_X: TPanel;
    Panel38: TPanel;
    Panel41: TPanel;
    mmComments: TMemo;
    tsBitmap: TTabSheet;
    Panel2: TPanel;
    scbPreview: TScrollBox;
    PrintDialog1: TPrintDialog;
    OpenDialog1: TOpenDialog;
    imgPreview: TImage;
    acShowHideNavigator: TAction;
    acMoveLeft: TAction;
    acMoveRight: TAction;
    acMoveUp: TAction;
    acMoveDown: TAction;
    acRedraw: TAction;
    chkb2_1: TCheckBox;
    chkb2_2: TCheckBox;
    GroupBox1: TGroupBox;
    Label86: TLabel;
    edt3_1_2: TEdit;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    lbl3_3_1: TLabel;
    lbl3_3_2: TLabel;
    edt3_3_1: TEdit;
    GroupBox4: TGroupBox;
    GroupBox5: TGroupBox;
    rgpb3_6: TGroupBox;
    chkb3_6_1: TCheckBox;
    chkb3_6_2: TCheckBox;
    chkb3_6_4: TCheckBox;
    chkb3_6_3: TCheckBox;
    chkb3_6_6: TCheckBox;
    chkb3_6_5: TCheckBox;
    GroupBox7: TGroupBox;
    chkb3_4_1: TCheckBox;
    chkb3_4_2: TCheckBox;
    chkb3_3_1: TCheckBox;
    chkb3_3_2: TCheckBox;
    chkb3_3_3: TCheckBox;
    chkb3_1_1: TCheckBox;
    chkb3_1_2: TCheckBox;
    chkb3_5_1: TCheckBox;
    chkb3_5_2: TCheckBox;
    chkb3_5_3: TCheckBox;
    chkb3_7_1: TCheckBox;
    chkb3_7_2: TCheckBox;
    chkb3_7_4: TCheckBox;
    edt3_7_1: TEdit;
    chkb3_7_3: TCheckBox;
    edt3_7_2: TEdit;
    GroupBox8: TGroupBox;
    Label36: TLabel;
    Label37: TLabel;
    Label38: TLabel;
    edt3_8_2: TEdit;
    edt3_8_1: TEdit;
    Label39: TLabel;
    edt3_8_4: TEdit;
    GroupBox9: TGroupBox;
    chkb4_2_1: TCheckBox;
    chkb4_2_2: TCheckBox;
    chkb4_2_3: TCheckBox;
    chkb4_2_4: TCheckBox;
    GroupBox10: TGroupBox;
    chkb4_3_1: TCheckBox;
    chkb4_3_2: TCheckBox;
    chkb4_3_3: TCheckBox;
    edt4_3_1: TEdit;
    GroupBox11: TGroupBox;
    Label44: TLabel;
    chkb5_1_1: TCheckBox;
    chkb5_1_2: TCheckBox;
    chkb5_1_3: TCheckBox;
    GroupBox12: TGroupBox;
    Label24: TLabel;
    chkb5_2_1: TCheckBox;
    chkb5_2_2: TCheckBox;
    chkb5_2_3: TCheckBox;
    GroupBox13: TGroupBox;
    chkb5_3_1: TCheckBox;
    chkb5_3_2: TCheckBox;
    chkb5_3_3: TCheckBox;
    Label48: TLabel;
    GroupBox14: TGroupBox;
    Label25: TLabel;
    chkb5_4_1: TCheckBox;
    chkb5_4_2: TCheckBox;
    chkb5_4_3: TCheckBox;
    GroupBox15: TGroupBox;

    GroupBox16: TGroupBox;
    Label27: TLabel;

    GroupBox17: TGroupBox;
    GroupBox18: TGroupBox;
    GroupBox19: TGroupBox;
    GroupBox20: TGroupBox;
    Label52: TLabel;
    Label54: TLabel;
    Label55: TLabel;
    Label56: TLabel;
    Label57: TLabel;
    GroupBox21: TGroupBox;
    chkb5_11_1: TCheckBox;
    chkb5_11_2: TCheckBox;
    chkb5_11_3: TCheckBox;
    GroupBox22: TGroupBox;
    chkb5_12_1: TCheckBox;
    chkb5_12_2: TCheckBox;
    chkb5_12_3: TCheckBox;
    lblV_FIrst: TLabel;
    edV_FirstYear: TEdit;
    lblV_Last: TLabel;
    edV_LastYear: TEdit;
    GroupBox23: TGroupBox;
    chkb5_14_1: TCheckBox;
    chkb5_14_2: TCheckBox;
    chkb5_14_3: TCheckBox;
    lbl5_14_1: TLabel;
    edt5_14_1: TEdit;
    Label59: TLabel;
    Label62: TLabel;
    Label58: TLabel;
    GroupBox24: TGroupBox;
    Label51: TLabel;
    pnlCDC21_VI: TPanel;
    Label64: TLabel;
    Label68: TLabel;
    Label29: TLabel;
    GroupBox28: TGroupBox;
    Label26: TLabel;
    edt6_4_1: TEdit;
    chkb6_4_1: TCheckBox;
    chkb6_4_2: TCheckBox;
    chkb6_4_3: TCheckBox;
    chkb6_4_4: TCheckBox;
    edt6_4_2: TEdit;
    GroupBox27: TGroupBox;
    Label67: TLabel;
    edt6_3_1: TEdit;
    chkb6_3_1: TCheckBox;
    chkb6_3_2: TCheckBox;
    chkb6_3_3: TCheckBox;
    chkb6_3_4: TCheckBox;
    GroupBox26: TGroupBox;
    Label69: TLabel;
    edt6_2_1: TEdit;
    chkb6_2_1: TCheckBox;
    chkb6_2_2: TCheckBox;
    chkb6_2_3: TCheckBox;
    Panel5: TPanel;
    Panel6: TPanel;
    GroupBox25: TGroupBox;
    Label65: TLabel;
    edt6_1_1: TEdit;
    chkb6_1_1: TCheckBox;
    chkb6_1_2: TCheckBox;
    chkb6_1_3: TCheckBox;
    GroupBox29: TGroupBox;
    lbl6_5_1: TLabel;
    edt6_5_1: TEdit;
    edt6_5_2: TEdit;
    edt6_5_3: TEdit;
    chkb6_5_1: TCheckBox;
    chkb6_5_2: TCheckBox;
    chkb6_5_3: TCheckBox;
    GroupBox30: TGroupBox;
    Label28: TLabel;
    Label30: TLabel;
    edt6_6_2: TEdit;
    cmbb6_6_1: TComboBox;
    edt6_6_1: TEdit;
    GroupBox31: TGroupBox;
    lbl6_8_1: TLabel;
    Label35: TLabel;
    chkb6_8_1: TCheckBox;
    chkb6_8_2: TCheckBox;
    chkb6_8_3: TCheckBox;
    edt6_8_1: TEdit;
    GroupBox32: TGroupBox;
    Label32: TLabel;
    edt6_7_1: TEdit;
    edt6_7_2: TEdit;
    Label42: TLabel;
    GroupBox33: TGroupBox;
    edt6_9_2: TEdit;
    edt6_9_4: TEdit;
    edt6_9_6: TEdit;
    edt6_9_8: TEdit;
    Label45: TLabel;
    Label47: TLabel;
    edt6_9_3: TEdit;
    edt6_9_1: TEdit;
    Label49: TLabel;
    Label50: TLabel;
    Label53: TLabel;
    Label66: TLabel;
    edt6_9_5: TEdit;
    edt6_9_7: TEdit;
    GroupBox34: TGroupBox;
    edt8_2_1: TEdit;
    Label96: TLabel;
    chkb8_2_1: TCheckBox;
    GroupBox35: TGroupBox;
    edt8_3_1: TEdit;
    Label97: TLabel;
    chkb8_3_1: TCheckBox;
    chkb8_3_2: TCheckBox;
    GroupBox36: TGroupBox;
    edt8_4_1: TEdit;
    chkb8_4_1: TCheckBox;
    Label98: TLabel;
    GroupBox37: TGroupBox;
    edt8_5_1: TEdit;
    chkb8_5_1: TCheckBox;
    Label99: TLabel;
    GroupBox38: TGroupBox;
    edt8_6_1: TEdit;
    chkb8_6_1: TCheckBox;
    GroupBox39: TGroupBox;
    edt8_7_1: TEdit;
    chkb8_7_1: TCheckBox;
    Label100: TLabel;
    Label101: TLabel;
    GroupBox40: TGroupBox;
    edt8_8_1: TEdit;
    chkb8_8_1: TCheckBox;
    Label102: TLabel;
    GroupBox41: TGroupBox;
    edt8_9_1: TEdit;
    chkb8_9_1: TCheckBox;
    chkb8_9_2: TCheckBox;
    Label103: TLabel;
    GroupBox42: TGroupBox;
    edt8_10_1: TEdit;
    chkb8_10_1: TCheckBox;
    GroupBox43: TGroupBox;
    edt8_11_1: TEdit;
    chkb8_11_1: TCheckBox;
    GroupBox44: TGroupBox;
    edt8_12_1: TEdit;
    chkb8_12_1: TCheckBox;
    GroupBox45: TGroupBox;
    edt8_13_1: TEdit;
    chkb8_13_1: TCheckBox;
    Label104: TLabel;
    Label105: TLabel;
    Label106: TLabel;
    Label107: TLabel;
    GroupBox46: TGroupBox;
    edt8_14_1: TEdit;
    chkb8_14_1: TCheckBox;
    chkb8_14_2: TCheckBox;
    Label108: TLabel;
    chkb8_1: TCheckBox;
    chkb8_2: TCheckBox;
    GroupBox47: TGroupBox;
    Label82: TLabel;
    Label83: TLabel;
    edt8_1_1: TEdit;
    edt8_1_2: TEdit;
    GroupBox48: TGroupBox;
    Label84: TLabel;
    edt8_15_1: TEdit;
    chkb8_15_1: TCheckBox;
    GroupBox49: TGroupBox;
    Label89: TLabel;
    edt8_16_1: TEdit;
    chkb8_16_1: TCheckBox;
    GroupBox50: TGroupBox;
    Label91: TLabel;
    edt8_17_1: TEdit;
    chkb8_17_1: TCheckBox;
    GroupBox51: TGroupBox;
    Label92: TLabel;
    edt8_18_1: TEdit;
    chkb8_18_1: TCheckBox;
    chkb8_18_2: TCheckBox;
    GroupBox52: TGroupBox;
    Label93: TLabel;
    edt8_19_1: TEdit;
    chkb8_19_1: TCheckBox;
    chkb8_19_2: TCheckBox;
    GroupBox53: TGroupBox;
    Label94: TLabel;
    edt8_20_1: TEdit;
    chkb8_20_1: TCheckBox;
    chkb8_20_2: TCheckBox;
    GroupBox54: TGroupBox;
    Label109: TLabel;
    edt8_23_1: TEdit;
    chkb8_23_1: TCheckBox;
    chkb8_23_2: TCheckBox;
    GroupBox55: TGroupBox;
    Label110: TLabel;
    edt8_22_1: TEdit;
    chkb8_22_1: TCheckBox;
    chkb8_22_2: TCheckBox;
    GroupBox56: TGroupBox;
    Label112: TLabel;
    edt8_24_1: TEdit;
    chkb8_24_1: TCheckBox;
    GroupBox57: TGroupBox;
    Label114: TLabel;
    edt8_25_1: TEdit;
    chkb8_25_1: TCheckBox;
    GroupBox58: TGroupBox;
    Label115: TLabel;
    edt8_26_1: TEdit;
    chkb8_26_1: TCheckBox;
    chkb8_26_2: TCheckBox;
    Label118: TLabel;
    GroupBox60: TGroupBox;
    Label119: TLabel;
    edt8_21_1: TEdit;
    chkb8_21_1: TCheckBox;
    chkb8_21_2: TCheckBox;
    edt8_1: TEdit;
    Label120: TLabel;
    GroupBox61: TGroupBox;
    Label121: TLabel;
    chkb8_28_1: TCheckBox;
    chkb8_28_2: TCheckBox;
    chkb8_28_3: TCheckBox;
    GroupBox62: TGroupBox;
    chkb9_1_1: TCheckBox;
    chkb9_1_2: TCheckBox;
    chkb9_1_3: TCheckBox;
    GroupBox63: TGroupBox;
    Label123: TLabel;
    chkb9_2_1: TCheckBox;
    chkb9_2_3: TCheckBox;
    chkb9_2_2: TCheckBox;
    chkb9_2_4: TCheckBox;
    GroupBox64: TGroupBox;
    chkb9_3_1: TCheckBox;
    chkb9_3_2: TCheckBox;
    chkb9_3_3: TCheckBox;
    Label124: TLabel;
    Label125: TLabel;
    GroupBox65: TGroupBox;
    Label126: TLabel;
    chkb9_4_1: TCheckBox;
    chkb9_4_2: TCheckBox;
    chkb9_4_4: TCheckBox;
    chkb9_4_3: TCheckBox;
    GroupBox66: TGroupBox;
    chkb9_5_1: TCheckBox;
    chkb9_5_2: TCheckBox;
    chkb9_5_3: TCheckBox;
    GroupBox67: TGroupBox;
    chkb9_6_1: TCheckBox;
    chkb9_6_2: TCheckBox;
    chkb9_6_3: TCheckBox;
    Label137: TLabel;
    Label138: TLabel;
    GroupBox68: TGroupBox;
    chkb9_7_1: TCheckBox;
    chkb9_7_2: TCheckBox;
    chkb9_7_4: TCheckBox;
    GroupBox69: TGroupBox;
    chkb9_8_1: TCheckBox;
    chkb9_8_2: TCheckBox;
    chkb9_8_4: TCheckBox;
    chkb9_8_3: TCheckBox;
    Label140: TLabel;
    Label141: TLabel;
    chkb9_7_3: TCheckBox;
    GroupBox70: TGroupBox;
    chkb9_9_1: TCheckBox;
    chkb9_9_3: TCheckBox;
    chkb9_9_2: TCheckBox;
    chkb9_9_4: TCheckBox;
    chkb9_9_5: TCheckBox;
    chkb9_9_6: TCheckBox;
    Label122: TLabel;
    GroupBox71: TGroupBox;
    chkb9_10_1: TCheckBox;
    chkb9_10_2: TCheckBox;
    chkb9_10_3: TCheckBox;
    Label144: TLabel;
    GroupBox72: TGroupBox;
    chkb9_11_1: TCheckBox;
    chkb9_11_2: TCheckBox;
    chkb9_11_3: TCheckBox;
    Label145: TLabel;
    GroupBox73: TGroupBox;
    chkb9_12_1: TCheckBox;
    chkb9_12_2: TCheckBox;
    chkb9_12_3: TCheckBox;
    Label146: TLabel;
    lbl9_12_1: TLabel;
    lbl9_12_2: TLabel;
    lbl9_12_3: TLabel;
    lbl9_12_5: TLabel;
    lbl9_12_6: TLabel;
    lbl9_12_4: TLabel;
    lbl9_12_7: TLabel;
    edt9_12_2: TEdit;
    edt9_12_5: TEdit;
    dtp9_12_1: TDateTimePicker;
    edt9_12_3: TEdit;
    edt9_12_1: TEdit;
    edt3_1_1: TEdit;
    Memo1: TMemo;
    chkb5_5_1: TCheckBox;
    chkb5_5_2: TCheckBox;
    chkb5_5_3: TCheckBox;
    chkb5_6_1: TCheckBox;
    chkb5_6_2: TCheckBox;
    chkb5_6_3: TCheckBox;
    chkb5_7_1: TCheckBox;
    chkb5_7_2: TCheckBox;
    chkb5_7_3: TCheckBox;
    chkb5_8_1: TCheckBox;
    chkb5_8_2: TCheckBox;
    chkb5_8_3: TCheckBox;
    chkb5_9_1: TCheckBox;
    chkb5_9_2: TCheckBox;
    chkb5_9_3: TCheckBox;
    chkb5_10_1: TCheckBox;
    chkb5_10_2: TCheckBox;
    chkb5_10_3: TCheckBox;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    Label17: TLabel;
    Label61: TLabel;
    GroupBox74: TGroupBox;
    Label40: TLabel;
    edt4_1_1: TEdit;
    Label41: TLabel;
    edt4_1_2: TEdit;
    Label46: TLabel;
    GroupBox59: TGroupBox;
    Label117: TLabel;
    edt8_27_1: TEdit;
    chkb8_27_1: TCheckBox;
    Label60: TLabel;
    ImageList1: TImageList;
    lbl6_4_1: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    acSave: TAction;
    acLoad: TAction;
    acBGImageSelect: TAction;
    acPrint: TAction;
    acSelectPrinter: TAction;
    acFontUp: TAction;
    acFontDown: TAction;
    fdlg: TFontDialog;
    acFontSelect: TAction;
    tsPage2: TTabSheet;
    scbPage2: TScrollBox;
    imgPreview2: TImage;
    pnlNavigator: TPanel;
    splNavigator: TSplitter;
    acSelectPage2: TAction;
    acSaveAsFile: TAction;
    acLoadFromFile: TAction;
    Label87: TLabel;
    acLoadParameters: TAction;
    edt3_2_1: TEdit;
    edt3_3_2: TEdit;
    acKillParams: TAction;
    Label31: TLabel;
    Label116: TLabel;
    edt3_8_5: TEdit;
    Label127: TLabel;
    edt4_1_4: TEdit;
    cmbb3_8_1: TComboBox;
    cmbb4_1_1: TComboBox;
    cmbb9_12_1: TComboBox;
    Button1: TButton;
    acZoomToFit: TAction;
    acZoomOne: TAction;
    acSubmit: TAction;
    acCancel: TAction;
    acZoomIn: TAction;
    acZoomOut: TAction;
    PageControl1: TPageControl;
    tsNavigator: TTabSheet;
    tsParams: TTabSheet;
    mmParams: TMemo;
    lvFields: TListView;
    Panel8: TPanel;
    spbSelectPage1: TSpeedButton;
    Label71: TLabel;
    Label72: TLabel;
    spbSelectPage2: TSpeedButton;
    Label85: TLabel;
    Label130: TLabel;
    Panel9: TPanel;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    Label63: TLabel;
    Label70: TLabel;
    lblMaxWidth: TLabel;
    Label74: TLabel;
    Label75: TLabel;
    lblMaxHeight: TLabel;
    Label78: TLabel;
    Label79: TLabel;
    Label73: TLabel;
    Label88: TLabel;
    Label90: TLabel;
    Label111: TLabel;
    Label76: TLabel;
    Label113: TLabel;
    SpeedButton9: TSpeedButton;
    Label77: TLabel;
    SpeedButton12: TSpeedButton;
    edtStep: TEdit;
    UpDown: TUpDown;
    edtFontSize: TEdit;
    edtCharSpace: TEdit;
    edtMaxChar: TEdit;
    edtMaxWidth: TEdit;
    edtMaxHeight: TEdit;
    edtY: TEdit;
    edtX: TEdit;
    edtPage: TEdit;
    edtKey: TEdit;
    edtPos: TEdit;
    edtCode: TEdit;
    edtMaxPos: TEdit;
    edtType: TEdit;
    edtComment: TEdit;
    edtPage1: TEdit;
    cmbbFormat: TComboBox;
    edtPage2: TEdit;
    Panel7: TPanel;
    Panel10: TPanel;
    SpeedButton13: TSpeedButton;
    Panel11: TPanel;
    Label128: TLabel;
    SpeedButton3: TSpeedButton;
    SpeedButton2: TSpeedButton;
    Panel12: TPanel;
    Panel13: TPanel;
    Label129: TLabel;
    SpeedButton8: TSpeedButton;
    SpeedButton11: TSpeedButton;
    cmbReportStyle: TComboBox;
    acPrintBlank: TAction;
    Label131: TLabel;
    Label132: TLabel;
    Label133: TLabel;
    Label134: TLabel;
    Label135: TLabel;
    Label147: TLabel;
    Label148: TLabel;
    edt1_7: TEdit;
    pnlToolbar: TPanel;
    tlbMainRight: TCCRToolBar;
    ToolBar1: TToolBar;
    spbShowNavigator: TSpeedButton;
    SpeedButton1: TSpeedButton;
    spbZoomIn: TSpeedButton;
    spbZoomOut: TSpeedButton;
    SpeedButton14: TSpeedButton;
    SpeedButton15: TSpeedButton;
    chkbAutoZoom: TCheckBox;
    SpeedButton10: TSpeedButton;
    SpeedButton16: TSpeedButton;
    btnCancel: TButton;
    Panel14: TPanel;
    btnSubmit: TBitBtn;
    BitBtn1: TBitBtn;
    Panel141: TPanel;
    chkb5_4_4: TCheckBox;
    chkb5_4_5: TCheckBox;
    chkb5_4_6: TCheckBox;
    edt5_4_1: TEdit;
    Label1: TLabel;
    StaticText8: TStaticText;
    StaticText17: TStaticText;
    StaticText26: TStaticText;
    StaticText29: TStaticText;
    StaticText35: TStaticText;
    StaticText42: TStaticText;
    StaticText45: TStaticText;
    StaticText50: TStaticText;
    StaticText61: TStaticText;
    StaticText64: TStaticText;
    StaticText65: TStaticText;
    StaticText67: TStaticText;
    StaticText68: TStaticText;
    StaticText69: TStaticText;
    StaticText80: TStaticText;
    StaticText81: TStaticText;
    StaticText84: TStaticText;
    StaticText89: TStaticText;
    StaticText91: TStaticText;
    StaticText92: TStaticText;
    StaticText93: TStaticText;
    StaticText94: TStaticText;
    StaticText95: TStaticText;
    StaticText96: TStaticText;
    StaticText97: TStaticText;
    StaticText98: TStaticText;
    StaticText99: TStaticText;
    StaticText100: TStaticText;
    StaticText101: TStaticText;
    StaticText102: TStaticText;
    StaticText103: TStaticText;
    StaticText104: TStaticText;
    StaticText105: TStaticText;
    StaticText106: TStaticText;
    StaticText107: TStaticText;
    StaticText108: TStaticText;
    StaticText109: TStaticText;
    StaticText110: TStaticText;
    StaticText112: TStaticText;
    StaticText114: TStaticText;
    StaticText115: TStaticText;
    StaticText117: TStaticText;
    StaticText121: TStaticText;
    StaticText122: TStaticText;
    StaticText123: TStaticText;
    StaticText124: TStaticText;
    StaticText125: TStaticText;
    StaticText126: TStaticText;
    StaticText136: TStaticText;
    StaticText137: TStaticText;
    StaticText138: TStaticText;
    StaticText139: TStaticText;
    StaticText140: TStaticText;
    StaticText141: TStaticText;
    StaticText142: TStaticText;
    StaticText143: TStaticText;
    StaticText144: TStaticText;
    StaticText145: TStaticText;
    StaticText146: TStaticText;
    StaticText147: TStaticText;
    stxtDateCompleted: TStaticText;
    stxt9_12_1: TStaticText;
    procedure acShowHideExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure tvOptionsChange(Sender: TObject; Node: TTreeNode);
    procedure tvOptionsMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure acShowHideNavigatorExecute(Sender: TObject);
    procedure cmbReportStyleChange(Sender: TObject);
    procedure acRedrawExecute(Sender: TObject);
    procedure lvFieldsChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure acMoveLeftExecute(Sender: TObject);
    procedure acMoveRightExecute(Sender: TObject);
    procedure acMoveUpExecute(Sender: TObject);
    procedure acMoveDownExecute(Sender: TObject);
    procedure acSaveExecute(Sender: TObject);
    procedure acLoadExecute(Sender: TObject);
    procedure acBGImageSelectExecute(Sender: TObject);
    procedure acPrintExecute(Sender: TObject);
    procedure acFontUpExecute(Sender: TObject);
    procedure UpDownChangingEx(Sender: TObject; var AllowChange: Boolean;
      NewValue: Smallint; Direction: TUpDownDirection);
    procedure acFontSelectExecute(Sender: TObject);
    procedure cmbbFormatChange(Sender: TObject);
    procedure edtXChange(Sender: TObject);
    procedure imgPreviewMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure mmCommentsChange(Sender: TObject);
    procedure acSelectPage2Execute(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure acLoadParametersExecute(Sender: TObject);
    procedure acSaveAsFileExecute(Sender: TObject);
    procedure acLoadFromFileExecute(Sender: TObject);
    procedure acKillParamsExecute(Sender: TObject);
    procedure pcCDCChange(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure acZoomToFitExecute(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure dtp2_1Change(Sender: TObject);
    procedure acZoomOneExecute(Sender: TObject);
    procedure acSubmitExecute(Sender: TObject);
    procedure acZoomInExecute(Sender: TObject);
    procedure acZoomOutExecute(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure acPrintBlankExecute(Sender: TObject);
  private
    { Private declarations }
    PtIEN,
    RegIEN: String;
    CDCRowFix1, CDCRowFix2: integer;
    Params:TstringList;
    States:TstringList;
    Operators:TstringList;
    TestCodes:TstringList;
    fScale:Double;
    bIgnore:Boolean;
    iCount: Extended;
    WinC:TWinControl;
    procedure ChkbChange(Sender: TObject);
    procedure EdChange(Sender: TObject);
    procedure CmbChange(Sender: TObject);
    procedure DTPChange(Sender: TObject);
    procedure ChkbEnter(Sender:TObject);
    procedure ChkbExit(Sender:TObject);

    procedure SetControlStatus(aC: array of TWinControl; aL: array of TLabel;aStatus: Boolean);
    procedure ProcessCheckBox(Sender:TObject);
    procedure ProcessComboBox(Sender:TObject);
    procedure ProcessEdit(Sender:TObject);

//    procedure MoveField(iX,iY: Integer);
    procedure DrawItems(Blank:Boolean);
    procedure FontSizeChange(up:Boolean);
    procedure UpdateSubItem(iField:Integer;sValue:String);
    procedure SetEditFields;
    procedure FieldOutput(aC:TCanvas;iField, X,Y: Integer);
    procedure ParamsLoad(aSL:TStrings);
    procedure SetParamByNum(aKey,aValue: String;aPos,aMax: Integer;anOption:String);
    function ParamLineGet(i:Integer): String;
    procedure ParamLineSet(i: Integer;sValue:String);
    function ParamNameByNum(i: Integer):String;
    procedure ParamLoadFromList(aL:TStrings);
    procedure DateFieldOnExit(Sender:TObject);
    procedure DateFieldOnKeyPress(Sender: TObject; var Key: Char);
    procedure ZipFieldOnKeyPress(Sender: TObject; var Key: Char);

    procedure PanelControlsSet(aPnl:TPanel;var iNum: Integer; var aC:String);
    procedure PanelControlsUPdate(aPnl:TPanel);
    procedure ReAssignControls;
    procedure Section508Fixes;

    procedure RefreshColors;
    procedure RefreshPanels;
    procedure PanelControlsRefreshColors(aPnl:TPanel);

    procedure SetFormStatus(aStatus:Boolean);
    procedure CleanUpFields(aPnl:TPanel);

    procedure SaveLayout;
    procedure LoadLayout;
    procedure UpdateImageScale(aScale:Double);

    procedure PrintCDCForm(bBlank:Boolean);
    procedure setComboBox(ctrl: TComboBox; const anIndex: Integer); overload;
    procedure setComboBox(ctrl: TComboBox; const aValue: String); overload;
    procedure setDTP(ctrl: TDateTimePicker; const aValue: String);

  public
    procedure SetUpForm(aRegistry,aPatient:String;bReadOnly:Boolean;slData:TStrings);

  published
    procedure ApplyOptions;

  end;

var
  FormCDC: TFormCDC;

implementation
{$R *.DFM}

uses
  uROR_CommonUtils, uROR_Common, uROR_Utilities, StrUtils, uROR_Strings,
  Printers, uROR_Broker, fROR_VUSelector, fROR_Options, DateUtils, uROR_Classes;

const
  stDefault = 0; //Default Icon Index
  stChanged = 2; //Changed Icon Index
  stInvalid = 1; //Invalid Icon Index

  iDelta = 65; // Adjustment

  iType = 0;
  iName = 1;
  iInternal = 2; // Internal column index
  iExternal = 3; // External Column index
  iXCoord = 5;
  iYCoord = 6;
  iFontSize = 7;
  iFormat = 8;
  iCharSpace = 9;
  iMaxChar = 10;
  iMaxWidth = 11;
  iMaxHeight = 12;
  iPage = 13;
  iKeyWord = 14;
  iPos = 15;
  iCode = 16;
  iMaxPos = 17;
  iComment = 18;

  sRadioInternalChecked = '1';
  sRadioExternalChecked = 'X';
  sRadioInternalUnChecked = '0';
  sRadioExternalUnChecked = '';

  sCheckInternalChecked = '1';
  sCheckExternalChecked = 'X';
  sCheckInternalUnChecked = '0';
  sCheckExternalUnChecked = '';

                  // 1         11        21     28      36      44   49     56   61   66   71 74
  sFormatKeywords = 'BoxedLine PlainLine Number Percent TextBox MMYY MMDDYY ZIP5 ZIP9 MEMO N4 N7';
                 // 1   4   8   12  16  20  24  28  32  36  40  44  48  52  56
  sParamKeywords = 'DEM ADR RCE ETN HDR CDM FD  PH  LD1 LD2 CS  AID TS1 TS2 CMT ';
  sDelims = '^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^';

  clrSelected = clBlue;
  clrNormal = clBlack;

  iTestCount = 350;

  idfFontSize = 32;
  idfCharSpace = 49;

  iCommentsLineLimit = 3;
  iCommentsLineLength = 130;

  sCDCListText = 'CDCList.txt';
  sCDCListDB = 'ICRCDCDEF';

procedure TFormCDC.acShowHideExecute(Sender: TObject);
begin
  pnlTree.Visible := not pnlTree.Visible;
  FormResize(Self);
end;

procedure TFormCDC.ApplyOptions;
var
  ie: TCCRInterfaceElement;
begin
  ie := CCROptions.IE[ieReadOnly];
  tvOptions.Color := ie.Color;
  tvOptions.Font.Color := ie.FontColor;
end;

procedure TFormCDC.FormCreate(Sender: TObject);
var
  i: integer;
  tn: TTreeNode;
  pnl:TPanel;
  iTagNum : Integer;
  aCaption : String;
begin
  Params := TStringList.Create;
  Operators := TStringList.Create;
  States := TStringList.Create;

  TestCodes := TStringList.Create;
  TestCodes.Add('');
  TestCodes.Add('11');
  TestCodes.Add('12');
  TestCodes.Add('13');
  TestCodes.Add('18');

  iTagNum := 0;
  iCount := 0;
  aCaption := '';
  bIgnore := True;
  for i := 0 to sbCDC21.ControlCount - 1 do
    begin
      if (sbCDC21.Controls[i] is TPanel) and (TPanel(sbCDC21.Controls[i]).Visible) then
        begin
          pnl := TPanel(sbCDC21.Controls[i]);
          iCount := iCount + pnl.Height;
          PanelControlsSet(pnl,iTagNum,aCaption);

          tn := tvOptions.Items.Add(nil,aCaption);
          tn.Data := pnl;
        end
    end;

 if Broker.CallProc(rpcStatesList,['']) then
   begin
     States.Add('0');
     cmbb4_1_1.Items.Add('');
     cmbb3_8_1.Items.Add('');
     for i := 1to Broker.Results.Count - 1 do
       begin
         States.Add(piece(Broker.Results[i],'^',1));
         cmbb4_1_1.Items.Add(piece(Broker.Results[i],'^',2));
         cmbb3_8_1.Items.Add(piece(Broker.Results[i],'^',2));
//         cmbb9_12_1.Items.Add(piece(RPCBroker.Results[i],'^',2));
       end;
  end;

  Height := 600;
  Width := 800;

{$IFDEF AANTEST}
  splNavigator.Visible := True;
  splNavigator.align := alTop;
  pnlNavigator.Visible := True;
  splNavigator.align := alBottom;
  spbShowNavigator.Visible := True;
{$ENDIF}

  bIgnore := False;
  fScale := 1.0;
  try
    tvOptions.Selected := tvOptions.Items[0];
  except
  end;

  edtPage1.Text := CCROptions.CDC1Bmp;
  edtPage2.Text := CCROptions.CDC2Bmp;

  acLoadExecute(Self);
  ReAssignControls;
  acZoomToFitExecute(Self);

  LoadLayout;
  pcCDCChange(self);
  ApplyOptions;
end;

procedure TFormCDC.setComboBox(ctrl: TComboBox; const aValue: String);
var
  i: Integer;
begin
  i := ctrl.Items.IndexOf(aValue);
  setComboBox(ctrl, i);
end;

procedure TFormCDC.setComboBox(ctrl: TComboBox; const anIndex: Integer);
begin
  if anIndex > 0 then
    ctrl.ItemIndex := anIndex
  else
    ctrl.ItemIndex := 0;
  CmbChange(ctrl);
end;

procedure TFormCDC.setDTP(ctrl: TDateTimePicker; const aValue: String);
var
  c: Integer;
  d: Double;
begin
  try
    Val(aValue, d, c);
  except
    d := 0;
  end;
  if d > 0 then
    ctrl.Date := FMDateToWindowsDate(d)
  else
    ctrl.Date := DateOf(Now);
  DTPChange(ctrl);
end;

procedure TFormCDC.tvOptionsChange(Sender: TObject; Node: TTreeNode);
var
  i,j: Integer;
begin
  j := 0;
  for i := 0 to sbCDC21.ControlCount - 1 do
    begin
      if sbCDC21.Controls[i] = Node.Data then break;
      j := J + TPanel(sbCDC21.Controls[i]).Height;
    end;
  j := j * sbCDC21.VertScrollBar.Range;
  try
    pcCDC.ActivePage := tsForm;
    activeControl := sbCDC21;
  except
  end;
  sbCDC21.VertScrollBar.Position :=  Round( j / iCount) - iDelta;
  for i := 0 to TPanel(Node.Data).ControlCount - 1 do
    begin
      if TWinControl(TPanel(Node.Data).Controls[i]).TabOrder = 1 then
        begin
          WinC := TWinControl(TPanel(Node.Data).Controls[i]);
          pnlDetailsHeader.Caption := TWinControl(TPanel(Node.Data).Controls[i]).Name;
          break;
        end;
    end;
end;

procedure TFormCDC.tvOptionsMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  try
    ActiveControl := WinC;
  except
  end;
end;

procedure TFormCDC.acShowHideNavigatorExecute(Sender: TObject);
begin
  if pnlNavigator.Visible then splNavigator.Align := alTop;
  pnlNavigator.Visible := not pnlNavigator.Visible;
  if pnlNavigator.Visible then splNavigator.Align := alBottom;
end;

////////////////////////////////////////////////////////////////////////////////
procedure TFormCDC.EdChange(Sender: TObject);
var
  i: Integer;
begin
  i := TEdit(Sender).Tag;
  lvFields.Items[i].SubItems[iInternal] := Tedit(Sender).Text;
  lvFields.Items[i].SubItems[iExternal] := Tedit(Sender).Text;
  lvFields.Items[i].StateIndex := stChanged;

  SetParamByNum(
    lvFields.Items[i].SubItems[iKeyWord],
    lvFields.Items[i].SubItems[iInternal],
    intVal(lvFields.Items[i].SubItems[iPos]),
    intVal(lvFields.Items[i].SubItems[iMaxPos]),
    lvFields.Items[i].SubItems[iMaxHeight] //Sorry it will contain an option
  );
end;

procedure TFormCDC.ChkbChange(Sender: TObject);
var
  sCode: String;
  winc: TWinControl;
  i,j: Integer;
begin
  if bIgnore then Exit;
  i := TCheckBox(Sender).Tag;
  if TCheckBox(Sender).Checked then
    begin
      lvFields.Items[i].SubItems[iInternal] := sCheckInternalChecked;//'1'
      lvFields.Items[i].SubItems[iExternal] := sCheckExternalChecked;//'X'
    end
  else
    begin
      lvFields.Items[i].SubItems[iInternal] := sCheckInternalUnChecked;//'0'
      lvFields.Items[i].SubItems[iExternal] := sCheckExternalUnChecked;//' '
    end;

  lvFields.Items[i].StateIndex := stChanged;

  if TCheckBox(Sender).Checked then
    sCode :=lvFields.Items[i].SubItems[iCode]
  else
    sCode :='';

  SetParamByNum(
    lvFields.Items[i].SubItems[iKeyWord],
    sCode,
    intVal(lvFields.Items[i].SubItems[iPos]),
    intVal(lvFields.Items[i].SubItems[iMaxPos]),
    lvFields.Items[i].SubItems[iMaxHeight]//Sorry it will contain an option
  );

  if not TCheckBox(Sender).Checked then exit;

  bIgnore := True;
  winc := TCheckBox(Sender).Parent;
  for i := 0 to winc.ControlCount - 1 do
    if (winc.Controls[i] is TCheckBox) and
       (TCheckBox(winc.Controls[i]) <> TCheckBox(Sender)) then
        begin
          TCheckBox(winc.Controls[i]).Checked := False;
          j := TCheckBox(winc.Controls[i]).tag;
          lvFields.Items[j].SubItems[iInternal] := sCheckInternalUnChecked;//'0'
          lvFields.Items[j].SubItems[iExternal] := sCheckExternalUnChecked;//' '
        end;
  bIgnore := False;
end;

procedure TFormCDC.CmbChange(Sender: TObject);
var
  i: Integer;
  val: String;
begin
  i := TComboBox(Sender).Tag;

  if Sender = cmbb6_6_1 then
    begin
      if cmbb6_6_1.ItemIndex > 0 then
        val := TestCodes.Strings[cmbb6_6_1.ItemIndex]
      else
        val := '';
      lvFields.Items[i].SubItems[iInternal] := val;
      lvFields.Items[i].SubItems[iExternal] := val;
    end
  else  if (Sender = cmbb3_8_1) then
    begin
      if cmbb3_8_1.ItemIndex > 0 then
        lvFields.Items[i].SubItems[iInternal] := States.Strings[cmbb3_8_1.ItemIndex]
      else
        lvFields.Items[i].SubItems[iInternal] := '';
      lvFields.Items[i].SubItems[iExternal] := cmbb3_8_1.Text;
    end
  else if (Sender = cmbb4_1_1) then
    begin
      if cmbb4_1_1.ItemIndex > 0 then
        lvFields.Items[i].SubItems[iInternal] := States.Strings[cmbb4_1_1.ItemIndex]
      else
        lvFields.Items[i].SubItems[iInternal] := '';
      lvFields.Items[i].SubItems[iExternal] := cmbb4_1_1.Text;
    end
  else  if (Sender = cmbb9_12_1) then
    begin
//      lvFields.Items[i].SubItems[iInternal] := States.Strings[cmbb9_12_1.ItemIndex];
      lvFields.Items[i].SubItems[iInternal] := cmbb9_12_1.Text;
      lvFields.Items[i].SubItems[iExternal] := cmbb9_12_1.Text;
    end
  else
    begin
      lvFields.Items[i].SubItems[iInternal] := TComboBox(Sender).Text;
    end;

  lvFields.Items[i].StateIndex := stChanged;

  SetParamByNum(
    lvFields.Items[i].SubItems[iKeyWord],
    lvFields.Items[i].SubItems[iInternal],
    intVal(lvFields.Items[i].SubItems[iPos]),
    intVal(lvFields.Items[i].SubItems[iMaxPos]),
    lvFields.Items[i].SubItems[iMaxHeight]//Sorry it will contain an option
  );
end;

procedure TFormCDC.DTPChange(Sender: TObject);
var
  i: Integer;
begin
  if Sender = dtp9_12_1 then
    dtp2_1Change(Sender)
  else
    begin
      i := TDateTimePicker(Sender).Tag;
      lvFields.Items[i].SubItems[iInternal] := DateToStr(TDateTimePicker(Sender).Date);
      lvFields.Items[i].SubItems[iExternal] := DateToStr(TDateTimePicker(Sender).Date);
      lvFields.Items[i].StateIndex := stChanged;
      SetParamByNum(
        lvFields.Items[i].SubItems[iKeyWord],
        lvFields.Items[i].SubItems[iInternal],
        intVal(lvFields.Items[i].SubItems[iPos]),
        intVal(lvFields.Items[i].SubItems[iMaxPos]),
        lvFields.Items[i].SubItems[iMaxHeight]//Sorry it will contain an option
      );
    end;
end;
////////////////////////////////////////////////////////////////////////////////
procedure TFormCDC.ChkbEnter(Sender: TObject);
begin
  TCheckBox(Sender).Font.Color := clrSelected;
end;

procedure TFormCDC.ChkbExit(Sender: TObject);
begin
  TCheckBox(Sender).Font.Color := clrNormal;
end;

procedure TFormCDC.cmbReportStyleChange(Sender: TObject);
begin
  case cmbReportStyle.ItemIndex of
   0:lvFields.ViewStyle := vsIcon;
   1:lvFields.ViewStyle := vsList;
   2:lvFields.ViewStyle := vsReport;
   3:lvFields.ViewStyle := vsSmallIcon;
  end;
end;

procedure TFormCDC.acRedrawExecute(Sender: TObject);
begin
  //Redraw Preview Screen
  DrawItems(False);
end;

procedure TFormCDC.SetControlStatus(aC: array of TWinControl; aL: array of TLabel;aStatus: Boolean);
var
  i,ii: Integer;
begin
  for i := Low(aC) to  High(aC) do
    try
      aC[i].Enabled := aStatus;
      if aC[i] is TComboBox then
        begin
          if aStatus then
            begin
              TComboBox(aC[i]).Color := clWindow;
              TCOmboBox(aC[i]).Enabled := True;
              ii := TEdit(aC[i]).Tag;
              SetParamByNum(
                lvFields.Items[ii].SubItems[iKeyWord],
                lvFields.Items[ii].SubItems[iInternal],
                intVal(lvFields.Items[ii].SubItems[iPos]),
                intVal(lvFields.Items[ii].SubItems[iMaxPos]),
                lvFields.Items[i].SubItems[iMaxHeight]//Sorry it will contain an option
              );
            end
          else
            begin
              TComboBox(aC[i]).Color := clBtnFace;
              TComboBox(aC[i]).Enabled := False;
            end;
        end
      else if aC[i] is TEdit then
        begin
          if aStatus then
            begin
              TEdit(aC[i]).Color := clWindow;
              ii := TEdit(aC[i]).Tag;
              SetParamByNum(
                lvFields.Items[ii].SubItems[iKeyWord],
                lvFields.Items[ii].SubItems[iInternal],
                intVal(lvFields.Items[ii].SubItems[iPos]),
                intVal(lvFields.Items[ii].SubItems[iMaxPos]),
                lvFields.Items[i].SubItems[iMaxHeight]//Sorry it will contain an option
              );
            end
          else
            begin
              TEdit(aC[i]).Color := clBtnFace;
              TEdit(aC[i]).Text := '';
            end;
        end
      else if aC[i] is TDateTimePicker then
        begin
          if aStatus then
            TDateTimePicker(aC[i]).Color := clWindow
          else
            TDateTimePicker(aC[i]).Color := clBtnFace;
        end;
    except
    end;
  for i := Low(aL) to  High(aL) do
    try
      aL[i].Enabled := aStatus;
    except
    end;
end;

procedure TFormCDC.ProcessComboBox(Sender: TObject);
begin
  CmbChange(Sender);
end;

procedure TFormCDC.ProcessCheckBox(Sender: TObject);
begin
  ChkbChange(Sender);
  if TCheckBox(Sender) = chkb9_12_1 then
    begin
      SetControlStatus([dtp9_12_1,edt9_12_1,edt9_12_2,edt9_12_3,cmbb9_12_1,edt9_12_5],
                   [lbl9_12_1,lbl9_12_2,lbl9_12_3,lbl9_12_4,lbl9_12_5,lbl9_12_6,lbl9_12_7],
                   TCheckBox(Sender).Checked);
      if not TCheckBox(Sender).Checked then
        begin
          cmbb9_12_1.ItemIndex := 0;
          CmbChange(cmbb9_12_1);
          dtp9_12_1.Format := ' ';
          dtp9_12_1.OnChange(dtp9_12_1);
        end
      else
        dtp9_12_1.Format := '';
    end
  else if TCheckBox(Sender) = chkb3_1_1 then
    SetControlStatus([edt3_1_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb3_1_2 then
    SetControlStatus([edt3_1_2],[],TCheckBox(Sender).Checked)

  else if TCheckBox(Sender) = chkb3_3_2 then
    SetControlStatus([edt3_3_2,edt3_3_1],[lbl3_3_2,lbl3_3_1],TCheckBox(Sender).Checked)

  else if TCheckBox(Sender) = chkb3_7_2 then
    SetControlStatus([edt3_7_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb3_7_3 then
    SetControlStatus([edt3_7_2],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb4_3_3 then
    SetControlStatus([edt4_3_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb5_4_6 then
    SetControlStatus([edt5_4_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb5_12_1 then
    SetControlStatus([edV_FirstYear,edV_LastYear],
                   [lblV_First,lblV_Last],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb5_14_1 then
    SetControlStatus([edt5_14_1],[lbl5_14_1],TCheckBox(Sender).Checked)

  else if (TCheckBox(Sender) = chkb6_1_1) or (TCheckBox(Sender) = chkb6_1_2) then
    SetControlStatus([edt6_1_1],[],TCheckBox(Sender).Checked)

  else if (TCheckBox(Sender) = chkb6_2_1) or (TCheckBox(Sender) = chkb6_2_2) then
    SetControlStatus([edt6_2_1],[],TCheckBox(Sender).Checked)

  else if (TCheckBox(Sender) = chkb6_3_1) or (TCheckBox(Sender) = chkb6_3_2) or (TCheckBox(Sender) = chkb6_3_3) then
    SetControlStatus([edt6_3_1],[],TCheckBox(Sender).Checked)

  else if (TCheckBox(Sender) = chkb6_4_1) or (TCheckBox(Sender) = chkb6_4_2) or (TCheckBox(Sender) = chkb6_4_3) then
    SetControlStatus([edt6_4_1,edt6_4_2],[lbl6_4_1],TCheckBox(Sender).Checked)

  else if (TCheckBox(Sender) = chkb6_5_1)
       or (TCheckBox(Sender) = chkb6_5_2)
       or (TCheckBox(Sender) = chkb6_5_3) then
    begin
//      SetControlStatus([edt6_5_1,edt6_5_2,edt6_5_3],[lbl6_5_1],TCheckBox(Sender).Checked)
      SetControlStatus([edt6_5_1],[],TCheckBox(Sender).Checked);
      SetControlStatus([edt6_5_2,edt6_5_3],[lbl6_5_1], not TCheckBox(Sender).Checked);
    end

  else if TCheckBox(Sender) = chkb6_8_1 then
    SetControlStatus([edt6_8_1],[lbl6_8_1],TCheckBox(Sender).Checked)

  else if TCheckBox(Sender) = chkb8_2_1 then
    SetControlStatus([edt8_2_1],[],TCheckBox(Sender).Checked)
  else if (TCheckBox(Sender) = chkb8_3_1) or (TCheckBox(Sender) = chkb8_3_2) then
    SetControlStatus([edt8_3_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_4_1 then
    SetControlStatus([edt8_4_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_5_1 then
    SetControlStatus([edt8_5_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_6_1 then
    SetControlStatus([edt8_6_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_7_1 then
    SetControlStatus([edt8_7_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_8_1 then
    SetControlStatus([edt8_8_1],[],TCheckBox(Sender).Checked)
  else if (TCheckBox(Sender) = chkb8_9_1) or (TCheckBox(Sender) = chkb8_9_2) then
    SetControlStatus([edt8_9_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_10_1 then
    SetControlStatus([edt8_10_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_11_1 then
    SetControlStatus([edt8_11_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_12_1 then
    SetControlStatus([edt8_12_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_13_1 then
    SetControlStatus([edt8_13_1],[],TCheckBox(Sender).Checked)
  else if (TCheckBox(Sender) = chkb8_14_1) or (TCheckBox(Sender) = chkb8_14_2) then
    SetControlStatus([edt8_14_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_15_1 then
    SetControlStatus([edt8_15_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_16_1 then
    SetControlStatus([edt8_16_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_17_1 then
    SetControlStatus([edt8_17_1],[],TCheckBox(Sender).Checked)
  else if (TCheckBox(Sender) = chkb8_18_1) or (TCheckBox(Sender) = chkb8_18_2) then
    SetControlStatus([edt8_18_1],[],TCheckBox(Sender).Checked)
  else if (TCheckBox(Sender) = chkb8_19_1) or (TCheckBox(Sender) = chkb8_19_2) then
// 'defect' 96
    SetControlStatus([edt8_19_1],[],TCheckBox(Sender).Checked)
//    SetControlStatus([edt8_19_1,edt8_1],[],TCheckBox(Sender).Checked)
  else if (TCheckBox(Sender) = chkb8_20_1) or (TCheckBox(Sender) = chkb8_20_2) then
// 'defect' 96
    SetControlStatus([edt8_20_1],[],TCheckBox(Sender).Checked)
//    SetControlStatus([edt8_20_1,edt8_1],[],TCheckBox(Sender).Checked)
  else if (TCheckBox(Sender) = chkb8_21_1) or (TCheckBox(Sender) = chkb8_21_2) then
    SetControlStatus([edt8_21_1],[],TCheckBox(Sender).Checked)
  else if (TCheckBox(Sender) = chkb8_22_1) or (TCheckBox(Sender) = chkb8_22_2) then
    SetControlStatus([edt8_22_1],[],TCheckBox(Sender).Checked)
  else if (TCheckBox(Sender) = chkb8_23_1) or (TCheckBox(Sender) = chkb8_23_2) then
    SetControlStatus([edt8_23_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_24_1 then
    SetControlStatus([edt8_24_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_25_1 then
    SetControlStatus([edt8_25_1],[],TCheckBox(Sender).Checked)
  else if (TCheckBox(Sender) = chkb8_26_1) or (TCheckBox(Sender) = chkb8_26_2) then
    SetControlStatus([edt8_26_1],[],TCheckBox(Sender).Checked)
  else if TCheckBox(Sender) = chkb8_27_1 then
    SetControlStatus([edt8_27_1],[],TCheckBox(Sender).Checked);
end;

procedure TFormCDC.ProcessEdit(Sender: TObject);
begin
  EdChange(Sender);
  if TEdit(Sender) = edt6_9_1 then
    SetControlStatus([edt6_9_2],[],TEdit(Sender).Text <>'')
  else if TEdit(Sender) = edt6_7_1 then  // Jan 20, 2004
    SetControlStatus([edt6_7_2],[],TEdit(Sender).Text <>'')
  else if TEdit(Sender) = edt6_9_3 then
    SetControlStatus([edt6_9_4],[],TEdit(Sender).Text <>'')
  else if TEdit(Sender) = edt6_9_5 then
    SetControlStatus([edt6_9_6],[],TEdit(Sender).Text <>'')
  else if TEdit(Sender) = edt6_9_7 then
    SetControlStatus([edt6_9_8],[],TEdit(Sender).Text <>'');
end;

procedure TFormCDC.lvFieldsChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
var
  bOld: Boolean;
begin
  bOld := bIgnore;
  SetEditFields;
  bIgnore := bOld;
end;
{
procedure TfrmCDCList.MoveField(iX,iY: Integer);
var
  i,j: Integer;
begin
  try
    i := lvFields.Selected.Index;
    j := IntVal(lvFields.Items[i].SubItems[iXCoord]) + iX;
    lvFields.Items[i].SubItems[iXCoord] := intToStr(j);
    j := IntVal(lvFields.Items[i].SubItems[iYCoord]) + iY;
    lvFields.Items[i].SubItems[iYCoord] := intToStr(j);
    DrawItems(False);
  except
  end;
end;
}
procedure TFormCDC.acMoveLeftExecute(Sender: TObject);
var
  i,j: Integer;
begin
  try
    i := lvFields.Selected.Index;
    j := IntVal(lvFields.Items[i].SubItems[iXCoord]);
    j := j - IntVal(edtStep.Text);
    edtX.Text := IntToStr(j);
  except
  end;
end;

procedure TFormCDC.acMoveRightExecute(Sender: TObject);
var
  i,j: Integer;
begin
  try
    i := lvFields.Selected.Index;
    j := IntVal(lvFields.Items[i].SubItems[iXCoord]);
    j := j + IntVal(edtStep.Text);
    edtX.Text := IntToStr(j);
  except
  end;
end;

procedure TFormCDC.acMoveUpExecute(Sender: TObject);
var
  i,j: Integer;
begin
  try
    i := lvFields.Selected.Index;
    j := IntVal(lvFields.Items[i].SubItems[iYCoord]);
    j := J - IntVal(edtStep.Text);
    edtY.Text := IntToStr(j);
  except
  end;
end;

procedure TFormCDC.acMoveDownExecute(Sender: TObject);
var
  i,j: Integer;
begin
  try
    i := lvFields.Selected.Index;
    j := IntVal(lvFields.Items[i].SubItems[iYCoord]);
    j := J + IntVal(edtStep.Text);
    edtY.Text := IntToStr(j);
  except
  end;
end;

procedure TFormCDC.acSaveExecute(Sender: TObject);
var
  sL: TStringList;
  sValue,sName: String;
  i: Integer;
begin
  sL := TStringList.Create;
  sL.Add('');
  for i := 0 to lvFields.Items.Count - 1 do
    begin
      {$IFDEF AANTEST}
        if i > iTestCount then Break;
      {$ENDIF}
      sValue := ParamLineGet(i);
      sName := ParamNameByNum(i);
      sL.Add(sName + '='+sValue);
    end;
  if sL.Count > 1 then
    if not Broker.CallProc(rpcGUIParameterSet,[sCDCListDB,'PKG'],sL) then
      MessageDlg508('', 'Errors saving parameter List',mtError,[mbOK],0);
  sL.Free;
end;

procedure TFormCDC.acLoadExecute(Sender: TObject);
begin
  Broker.CreateResults;
  if Broker.CallProc(rpcGUIParameterGet,[sCDCListDB,'PKG']) then
    ParamLoadFromList(Broker.Results);
end;

procedure TFormCDC.acBGImageSelectExecute(Sender: TObject);
begin
  if OpenDialog1.Execute then
    edtPage1.Text := OpenDialog1.FileName;
  CCROptions.CDC1Bmp := edtPage1.Text;
end;

procedure TFormCDC.DrawItems(Blank:Boolean);
var
  iX, iY,
  i: Integer;
  bmp: TBitmap;
  bmp2: TBitmap;
  aFont:TFont;
begin
  if bIgnore then Exit;
  aFont := TFont.Create;
  bmp := TBitmap.Create;
  bmp.LoadFromFile(ExtractFilePath(Application.ExeName) + CCROptions.CDC1Bmp);
  imgPreview.Picture.Assign(bmp);

  bmp2 := TBitmap.Create;
  bmp2.LoadFromFile(ExtractFilePath(Application.ExeName) + CCROptions.CDC2Bmp);
  imgPreview2.Picture.Assign(bmp2);

  if not Blank then
  begin
    aFont.Assign(fdlg.Font);
    bmp.Canvas.Font.Assign(aFont);
    bmp2.Canvas.Font.Assign(aFont);

    imgPreview.Canvas.Font.Assign(aFont);
    imgPreview2.Canvas.Font.Assign(aFont);

    for i := 0 to lvFields.Items.Count - 1 do
    begin
      {$IFDEF AANTEST}
        if i > iTestCount then Break;
      {$ENDIF}
      iY := IntVal(lvFields.Items[i].SubItems[iYCoord]);
      iX := IntVal(lvFields.Items[i].SubItems[iXCoord]);

      if lvFields.Items[i].SubItems[iPage] = '1' then
      begin
        //-- Switch rows to fix transposed form and printout answers (Patch 17)
        if iY = CDCRowFix1 then
          iY := CDCRowFix2
        else if iY = CDCRowFix2 then
          iY := CDCRowFix1;

        imgPreview.Canvas.Font.Size := intVal(lvFields.Items[i].SubItems[iFontSize]);
        FieldOutput(imgPreview.Canvas,i,iX,iY);
      end
      else begin
        imgPreview2.Canvas.Font.Size := intVal(lvFields.Items[i].SubItems[iFontSize]);
        FieldOutput(imgPreview2.Canvas,i,iX,iY);
      end;
    end;
    aFont.Free;
  end;
  bmp.Free;
  bmp2.Free;
end;

procedure TFormCDC.acPrintExecute(Sender: TObject);
begin
  PrintCDCForm(False);
end;

procedure TFormCDC.PrintCDCForm(bBlank:Boolean);
var
  aRect:TRect;
begin
  DrawItems(bBlank);
  if PrintDialog1.Execute then
    with Printer do
      begin
        aRect.Top := 10;
        aRect.Left := 10;
        aRect.Bottom := Printer.PageHeight -10;
        aRect.Right := Printer.PageWidth -10;
        BeginDoc;
        Canvas.StretchDraw(aRect, imgPreview.Picture.Bitmap);
        NewPage;
        Canvas.StretchDraw(aRect, imgPreview2.Picture.Bitmap);
        EndDoc;
      end;
end;

procedure TFormCDC.FontSizeChange(up:Boolean);
var
  j: Integer;
begin
  try
    j := IntVal(edtFontSize.Text);
    if up then
      j := j + 1
    else
      j := j - 1;
    edtFontSize.Text :=  intToStr(j);
  except
  end;
end;

procedure TFormCDC.acFontUpExecute(Sender: TObject);
begin
  FontSizeChange(True);
end;

procedure TFormCDC.UpDownChangingEx(Sender: TObject;
  var AllowChange: Boolean; NewValue: Smallint;
  Direction: TUpDownDirection);
begin
  if updUp = Direction then
    FontSizeChange(True)
  else
    FontSizeChange(False);
end;

procedure TFormCDC.acFontSelectExecute(Sender: TObject);
begin
  fdlg.Execute;
end;

procedure TFormCDC.cmbbFormatChange(Sender: TObject);
var
  i: Integer;
begin
  try
    i := lvFields.Selected.Index;
    lvFields.Items[i].SubItems[iFormat] := cmbbFormat.Text;
  except
  end;
end;

procedure TFormCDC.UpdateSubItem(iField:Integer;sValue:String);
var
  i,j: Integer;
begin
  if not Assigned(lvFields.Selected) then
    exit; 
  i := lvFields.Selected.Index;
  j := lvFields.SelCount;
  while (J > 0) and (i < lvFields.Items.Count) do
    begin
      if lvFields.Items[i].Selected then
        try
          lvFields.Items[i].SubItems[iField] := sValue;
        except
        end;
      Inc(i);
    end;
end;

procedure TFormCDC.edtXChange(Sender: TObject);
var
  i: Integer;
begin
  i := -1;
  if      Sender = edtX then i := iXCoord
  else if Sender = edtY then i := iYCoord
  else if Sender = edtKey then i := iKeyWord
  else if Sender = edtPos then i := iPos
  else if Sender = edtPage then i := iPage
  else if Sender = edtCode then i := iCode
  else if Sender = edtType then i := iType
  else if Sender = edtMaxPos then i := iMaxPos
  else if Sender = edtComment then i := iComment
  else if Sender = edtMaxChar then i := iMaxChar
  else if Sender = edtFontSize then i := iFontSize
  else if Sender = edtMaxWidth then i := iMaxWidth
  else if Sender = edtCharSpace then i := iCharSpace
  else if Sender = edtMaxHeight then i := iMaxHeight;

  if i >= 0 then
    UPdateSubItem(i,TEdit(Sender).Text);

  DrawItems(False);
end;

procedure TFormCDC.SetEditFields;
var
  bOld: Boolean;
begin
  if lvFields.Selected = nil then exit;
  bOld := bIgnore;
  bIgnore := True;
  try
    edtX.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iXCoord];
    edtY.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iYCoord];
    edtFontSize.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iFontSize];
    edtCharSpace.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iCharSpace];
    edtMaxChar.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iMaxChar];
    edtMaxWidth.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iMaxWidth];
    edtMaxHeight.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iMaxHeight];
    edtPage.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iPage];

    edtKey.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iKeyword];
    edtPos.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iPos];
    edtCode.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iCode];
    edtMaxPos.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iMaxPos];
    edtType.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iType];
    edtComment.Text := lvFields.Items[lvFields.Selected.Index].SubItems[iComment];
  except
  end;
  bIgnore := bOld;
end;

procedure TFormCDC.imgPreviewMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if ssDouble in Shift then
    try
      bIgnore := True;
      edtX.Text := FloatToStr(Round(X*fScale));
      edtY.Text := FloatToStr(Round(Y*fScale));
      bIgnore := False;
      DrawItems(False);
    except
    end;
end;

procedure TFormCDC.FieldOutput(aC:TCanvas;iField, X,Y: Integer);
var
  iCS,iGroupSpace,
  i,j: Integer;
  s, sM, sY: String;
begin
                    // 1         11        21     28      36      44   49     56   61   66   71 74
//  sFormatKeywords = 'BoxedLine PlainLine Number Percent TextBox MMYY MMDDYY ZIP5 ZIP9 MEMO N4 N7';
  s := lvFields.Items[iField].SubItems[iFormat];
  j := pos(s,sFormatKeywords);
  iCS := IntVal(lvFields.Items[iField].SubItems[iCharSpace]);
  if lvFields.Items[iField].SubItems[iFormat] = '' then j := 0;
  case j of
    0,11:  aC.TextOut(X,Y,lvFields.Items[iField].SubItems[iExternal]);
    1: begin
        j := IntVal(lvFields.Items[iField].SubItems[iMaxChar]);
        if j > length(lvFields.Items[iField].SubItems[iExternal]) then
          j := length(lvFields.Items[iField].SubItems[iExternal]);
        for i := 1 to j do
            aC.TextOut(X+(i-1)*iCS,Y,copy(lvFields.Items[iField].SubItems[iExternal],i,1));
      end;
    28: begin
        s := lvFields.Items[iField].SubItems[iExternal];
        while Length(s) < 2 do
          s := '0'+s;
        for i := 1 to 2 do
            aC.TextOut(X+(i-1)*iCS,Y,copy(lvFields.Items[iField].SubItems[iExternal],i,1));
      end;
    44: begin
        iGroupSpace := IntVal(lvFields.Items[iField].SubItems[iMaxChar]);
        sM := Piece(lvFields.Items[iField].SubItems[iExternal],'/',1);
        sY := piece(lvFields.Items[iField].SubItems[iExternal],'/',2);

        if sY = '' then
          begin
            sY := sM;
            sM := '';
          end;

        if sM <> '' then
          begin
            i := Length(sM);
            if i < 2 then
              sM := '0' + sM
            else if i > 2 then
              Exit;
            for i := 1 to 2 do
              aC.TextOut(X+(i-1)*iCS,Y,copy(sM,i,1));
          end;

        if sY <> '' then
          begin
            case Length(sY) of
              1:
                sY := '0' + sY;
              2:;
              4:
                sY := AnsiRightStr(sY, 2);
              else
                Exit;
            end;
            for i := 1 to 2 do
              aC.TextOut(X+iGroupSpace+(i-2)*iCS,Y,copy(sY,i,1));
          end;
       end;
    49: begin
        iGroupSpace := IntVal(lvFields.Items[iField].SubItems[iMaxChar]);
        s := piece(lvFields.Items[iField].SubItems[iExternal],'/',1);
        if length(s) < 2 then s := '0'+s;
        if length(s) < 2 then exit;
        for i := 1 to 2 do
          aC.TextOut(X+(i-1)*iCS,Y,copy(s,i,1));
        s := piece(lvFields.Items[iField].SubItems[iExternal],'/',2);
        if length(s) < 2 then s := '0'+s;
        if length(s) < 2 then exit;
        for i := 1 to 2 do
          aC.TextOut(X+iGroupSpace+(i-1)*iCS,Y,copy(s,i,1));

        s := piece(lvFields.Items[iField].SubItems[iExternal],'/',3);
        if length(s) < 2 then s := '0'+s;
        if length(s) < 2 then exit;
        for i := 3 to 4 do
          aC.TextOut(X+iGroupSpace+iGroupSpace+(i-3)*iCS,Y,copy(s,i,1));
      end;
    66://we have only one memo field on the form
      begin
        for i := 0 to mmComments.Lines.Count - 1 do
          aC.TextOut(X,Y+i*iCS,mmComments.Lines[i]);
      end;
    71:
      begin
        iGroupSpace := IntVal(lvFields.Items[iField].SubItems[iMaxChar]);
        s := lvFields.Items[iField].SubItems[iExternal];
        if s = '' then exit;
        while Length(s) < 4 do
          s := '0'+s;
        aC.TextOut(X,Y,copy(s,1,1));
        for i := 2 to 4 do
          aC.TextOut(X+iGroupSpace+(i-1)*iCS,Y,copy(s,i,1));

      end;
    74:
      begin
        iGroupSpace := IntVal(lvFields.Items[iField].SubItems[iMaxChar]);
        s := lvFields.Items[iField].SubItems[iExternal];
        if s = '' then exit;
        while Length(s) < 7 do
          s := '0'+s;
        aC.TextOut(X,Y,copy(s,1,1));
        for i := 2 to 4 do
          aC.TextOut(X+iGroupSpace+(i-1)*iCS,Y,copy(s,i,1));
        for i := 5 to 7 do
          aC.TextOut(X+2*iGroupSpace+(i-1)*iCS,Y,copy(s,i,1));
      end;
  end;
end;

procedure TFormCDC.mmCommentsChange(Sender: TObject);
var
  s :String;
  i: Integer;
  SL: TStringList;
begin
  if bIgnore then exit;
  bIgnore := True;

  SL := TStringList.Create;
  SL.Text := mmComments.Text;
  i := 0;
  while (i < iCommentsLineLimit) and (i < SL.Count) do
    try
      if Length(SL[i])> iCommentsLineLength then
        begin
          s := SL[i];
          SL[i] := copy(s,1,iCommentsLineLength);
          if i+1 > SL.Count then
            SL.Add(copy(s,iCommentsLineLength+1,Length(s)))
          else
            SL[i+1] :=copy(s,iCommentsLineLength+1,Length(s)) + #13#10 +
              SL[i+1];
        end;
      inc(i);
    except
    end;

  mmComments.Text := SL.Text;
  SL.Free;

  while mmComments.Lines.Count > iCommentsLineLimit do
    mmComments.Lines.Delete(mmComments.Lines.Count-1);

  i := 0;
  while i < mmParams.Lines.Count do
    begin
      if pos('CMT',mmParams.Lines[i])=1 then
        mmParams.Lines.Delete(i)
      else
        inc(i);
    end;

  for i := 0 to iCommentsLineLimit-1 do
      mmParams.Lines.Add('CMT^'+IntToStr(i+1)+'^'+mmComments.Lines[i]);
  bIgnore := False;
end;

procedure TFormCDC.acSelectPage2Execute(Sender: TObject);
begin
  if OpenDialog1.Execute then
    edtPage2.Text := OpenDialog1.FileName;
  CCROptions.CDC2Bmp := edtPage2.Text;
end;

procedure TFormCDC.ParamsLoad(aSL:TStrings);
var
  c: Integer;
  d: Double;
  i,iIndex,iDC: Integer;
  s,sLine,sName,sV,ss: String;
begin
  mmParams.Text := aSL.Text;
  if not Assigned(Params) then
    Params := TStringList.Create;
  Params.Clear;
  mmComments.Clear;
  RefreshPanels;
//                    1   5   9   13  17  21  25  29  33  37  41  45  49  53  57
//  sParamKeywords = 'DEM ADR RCE ETN HDR CDM FD  PH  LD1 LD2 CS  AID TS1 TS2 CMT ';
  for i := 1 to aSL.Count -1 do
    begin
      sName := piece(aSL[i],'^',1);
      sV := aSL[i];
      sLine := sName+'='+sV;
      Params.Add(sLine);
      //Assign GUI controls;
      iIndex := pos(sName,sParamKeywords);
      case iIndex of
        0:;
        1:begin//DEM
           edt1_1.Text := piece(sV,'^',4) + '  ('+piece(sV,'^',5)+')';
           try
             Val( piece(sV,'^',5),d,c);
             if D<>0 then
               edt3_2_1.Text := DateToStr(FMDateToWindowsDate(d));
           except
           end;
           try
             Val( piece(sV,'^',7),d,c);
             if D<>0 then
               edt3_3_2.Text := DateToStr(FMDateToWindowsDate(d));
           except
           end;
           chkb3_4_1.Checked := piece(sV,'^',8) = 'M';
           chkb3_4_2.Checked := piece(sV,'^',8) = 'F';
//           if chkb3_4_1.Checked then // Male vs. Female
             begin
               chkb9_10_1.Enabled := chkb3_4_2.Checked ;
               chkb9_10_2.Enabled := chkb3_4_2.Checked ;
               chkb9_10_3.Enabled := chkb3_4_2.Checked ;
               chkb9_11_1.Enabled := chkb3_4_2.Checked ;
               chkb9_11_2.Enabled := chkb3_4_2.Checked ;
               chkb9_11_3.Enabled := chkb3_4_2.Checked ;
               chkb9_12_1.Enabled := chkb3_4_2.Checked ;
               chkb9_12_2.Enabled := chkb3_4_2.Checked ;
               chkb9_12_3.Enabled := chkb3_4_2.Checked ;
             end;
          end;
        5:begin//ADR
           edt1_3.Text := piece(sV,'^',3)+piece(sV,'^',4)+piece(sV,'^',5);
           edt1_4.Text := piece(sV,'^',6);
           cmbb1_1.Text := piece(sV,'^',8);
           edt1_5.Text := piece(sV,'^',12);
           edt1_2.Text := piece(sV,'^',13);
           s := piece(sV,'^',10);
           if s<>'' then s := '-'+s;
           edt1_6.Text := piece(sV,'^',9)+s;
           edt1_7.Text := piece(sV,'^',8);
          end;
        9:begin//RCE
          s := piece(sV,'^',3);
          if s = '1002-5' then chkb3_6_1.Checked := True;
          if s = '2028-9' then chkb3_6_2.Checked := True;
          if s = '2054-5' then chkb3_6_3.Checked := True;
//          if s = '0000-0' then chkb3_6_3.Checked := True;//Decline to answer
          if s = '2076-8' then chkb3_6_4.Checked := True;
          if s = '9999-4' then chkb3_6_6.Checked := True;
          if s = '2106-3' then chkb3_6_5.Checked := True;
          end;
        13:begin//ETH
          s := piece(sV,'^',3);
          if s = '2135-2' then chkb3_5_1.Checked := True;//Hispanic
          if s = '9999-4' then chkb3_5_2.Checked := True;//Unknown
          if s = '2186-5' then chkb3_5_3.Checked := True;//Not Hispanic or Latino
//          if s = '0000-0' then chkb3_6_3.Checked := True;//Decline to answer
          end;
        17:begin//HDR
            try
              Val( piece(sV,'^',3),d,c);
              if D<>0 then
                dtp2_1.Date := FMDateToWindowsDate(d);
              dtp2_1Change(dtp2_1);
            except
            end;
            edt7_2.Text := piece(sV,'^',7);//Medical Record Number
//            edt7_3.Text := piece(sV,'^',?);//Physician's phone #
            edt7_5.Text := piece(sV,'^',5);//Person, who filled the form. Name
            edt7_6.Text := piece(sV,'^',6);//Phone
          end;
        21:begin//CDM
            s := piece(sV,'^',3);//Status at Report
            if s = '1' then
              begin
                chkb3_1_1.Checked := true;
                edt3_1_1.Text := piece(sV,'^',4);
              end;
            if s = '2' then
              begin
                chkb3_1_2.Checked := true;
                edt3_1_2.Text := piece(sV,'^',4);
              end;

            s := piece(sV,'^',5);
            chkb3_3_1.Checked := s = '1';
            chkb3_3_2.Checked := s = '2';
            chkb3_3_3.Checked := s = '9';;

            edt3_3_1.Text := piece(sV,'^',6);//State/Territory of Death
            s := Piece(sV,'^',7);
            if s = '1' then chkb3_7_1.Checked := True;//US
            if s = '7' then
              begin
                chkb3_7_2.Checked := True;//US Depend
                edt3_7_1.Text := Piece(sV,'^',8);
              end;
            if s = '8' then
              begin
                chkb3_7_3.Checked := True;//Other
                edt3_7_2.Text := Piece(sV,'^',8);
              end;
            if s = '9' then chkb3_7_4.Checked := True;//Unk.

            edt3_8_1.Text := piece(sV,'^',9);//City
            edt3_8_2.Text := piece(sV,'^',10);//County
            c := States.IndexOf(Piece(sV,'^',11));
            setComboBox(cmbb3_8_1, c);
            edt3_8_4.Text := piece(sV,'^',14);//ZIP
            cmbb4_1_1.Text := piece(sV,'^',6);
            edt3_8_5.Text := piece(sV,'^',13);//Country
          end;
        25:begin//FD
            edt4_1_1.Text := piece(sV,'^',3);//Hospital
            edt4_1_2.Text := piece(sV,'^',4);//City
            c := States.IndexOf(piece(sV,'^',5));
            setComboBox(cmbb4_1_1, c);
            edt4_1_4.text := piece(sV,'^',7);//Country
            s :=piece(sV,'^',8);
            if s = '1' then chkb4_2_1.Checked := True;//Public
            if s = '2' then chkb4_2_2.Checked := True;//Private
            if s = '3' then chkb4_2_3.Checked := True;//Federal
            if s = '9' then chkb4_2_4.Checked := True;//Unk.

            s :=piece(sV,'^',9);
            if s = '1' then chkb4_3_1.Checked := True;//Physician, HMO
            if s = '31' then chkb4_3_2.Checked := True;//Hospital, Inpatiebt
            if s = '88' then chkb4_3_3.Checked := True;//Other
            edt4_3_1.Text := piece(sV,'^',10);

          end;
        29:begin//PH Patient History
           s:=piece(sV,'^',3);chkb5_1_1.Checked:=s='1';chkb5_1_2.Checked:=s='0';chkb5_1_3.Checked:=s='9';
           s:=piece(sV,'^',4);chkb5_2_1.Checked:=s='1';chkb5_2_2.Checked:=s='0';chkb5_2_3.Checked:=s='9';
           s:=piece(sV,'^',5);chkb5_3_1.Checked:=s='1';chkb5_3_2.Checked:=s='0';chkb5_3_3.Checked:=s='9';
           s:=piece(sV,'^',6);chkb5_4_1.Checked:=s='1';chkb5_4_2.Checked:=s='0';chkb5_4_3.Checked:=s='9';
           s:=piece(sV,'^',7);chkb5_4_4.Checked:=s='1';chkb5_4_5.Checked:=s='2';chkb5_4_6.Checked:=s='8';
           edt5_4_1.Text := piece(sV,'^',8);
           //-- Switch order on answers to next two questions (Patch 15)
           s:=piece(sV,'^',10);chkb5_5_1.Checked:=s='1';chkb5_5_2.Checked:=s='0';chkb5_5_3.Checked:=s='9';
           s:=piece(sV,'^',9);chkb5_6_1.Checked:=s='1';chkb5_6_2.Checked:=s='0';chkb5_6_3.Checked:=s='9';
           s:=piece(sV,'^',11);chkb5_7_1.Checked:=s='1';chkb5_7_2.Checked:=s='0';chkb5_7_3.Checked:=s='9';
           s:=piece(sV,'^',12);chkb5_8_1.Checked:=s='1';chkb5_8_2.Checked:=s='0';chkb5_8_3.Checked:=s='9';
           s:=piece(sV,'^',13);chkb5_9_1.Checked:=s='1';chkb5_9_2.Checked:=s='0';chkb5_9_3.Checked:=s='9';
           s:=piece(sV,'^',14);chkb5_10_1.Checked:=s='1';chkb5_10_2.Checked:=s='0';chkb5_10_3.Checked:=s='9';
           s:=piece(sV,'^',15);chkb5_11_1.Checked:=s='1';chkb5_11_2.Checked:=s='0';chkb5_11_3.Checked:=s='9';
           edV_FirstYear.Text := piece(sV,'^',16);
           edV_LastYear.Text := piece(sV,'^',17);
           s:=piece(sV,'^',18);chkb5_12_1.Checked:=s='1';chkb5_12_2.Checked:=s='0';chkb5_12_3.Checked:=s='9';
           s:=piece(sV,'^',19);chkb5_14_1.Checked:=s='1';chkb5_14_2.Checked:=s='0';chkb5_14_3.Checked:=s='9';
           edt5_14_1.Text := piece(sV,'^',20);
          end;
        33:begin//LD1
           s:=piece(sV,'^',3);chkb6_1_1.Checked:=s='1';chkb6_1_2.Checked:=s='0';chkb6_1_3.Checked:=s='9';
           edt6_1_1.Text := piece(sV,'^',4);
           s:=piece(sV,'^',5);chkb6_2_1.Checked:=s='1';chkb6_2_2.Checked:=s='0';chkb6_2_3.Checked:=s='9';
           edt6_2_1.Text := piece(sV,'^',6);

           s:=piece(sV,'^',7);chkb6_3_1.Checked:=s='1';chkb6_3_2.Checked:=s='0';chkb6_3_3.Checked:=s='8';chkb6_3_4.Checked:=s='9';
           edt6_3_1.Text := piece(sV,'^',8);

           s:=piece(sV,'^',9);chkb6_4_1.Checked:=s='1';chkb6_4_2.Checked:=s='0';chkb6_4_3.Checked:=s='8';chkb6_4_4.Checked:=s='9';
           edt6_4_1.Text := piece(sV,'^',10);
           edt6_4_2.Text := piece(sV,'^',11);

           s:=piece(sV,'^',12);chkb6_5_1.Checked:=s='1';chkb6_5_2.Checked:=s='0';chkb6_5_3.Checked:=s='3';
           edt6_5_1.Text := piece(sV,'^',13);
           edt6_5_2.Text := piece(sV,'^',14);
           edt6_5_3.Text := piece(sV,'^',15);

           s := Trim(piece(sV,'^',16));
           iDC := TestCodes.IndexOf(s);
           setComboBox(cmbb6_6_1, iDC);

           edt6_6_1.Text := piece(sV,'^',17);
           edt6_6_2.Text := piece(sV,'^',18);
          end;
        37:begin//LD2
           s := piece(sV,'^',3); edt6_7_2.Text := s;
           edt6_7_1.Text := piece(sV,'^',4);

           s:=piece(sV,'^',5);chkb6_8_1.Checked:=s='1';chkb6_8_2.Checked:=s='0';chkb6_8_3.Checked:=s='9';
           edt6_8_1.Text := piece(sV,'^',6);

           edt6_9_1.Text:=piece(sV,'^',7);edt6_9_2.Text:= piece(sV,'^',8);
           edt6_9_3.Text:=piece(sV,'^',9);edt6_9_4.Text:= piece(sV,'^',10);
           edt6_9_5.Text:=piece(sV,'^',11);edt6_9_6.Text:= piece(sV,'^',12);
           edt6_9_7.Text:=piece(sV,'^',13);edt6_9_8.Text:= piece(sV,'^',14);
          end;
        41: begin//CS
           s := piece(sV,'^',3);chkb8_1.Checked := s = '1';chkb8_2.Checked := s = '0';

           edt8_1_1.Text := piece(sV,'^',4);
           edt8_1_2.Text := piece(sV,'^',5);

           edt8_1.Text := piece(sV,'^',6);
           s:=piece(sV,'^',7);chkb8_28_1.Checked:=s='1';chkb8_28_2.Checked:=s='0';chkb8_28_3.Checked:=s='9';
          end;
        45:begin//AID
            iDC := IntVal(piece(sV,'^',2));
            s := piece(sV,'^',3);
            ss := piece(sV,'^',4);
            case iDC of
              1:begin chkb8_2_1.Checked := s = '1';                              edt8_2_1.Text:=ss; end;
              2:begin chkb8_3_1.Checked := s = '1';chkb8_3_2.Checked := s = '2'; edt8_3_1.Text:=ss; end;
              3:begin chkb8_4_1.Checked := s = '1';                              edt8_4_1.Text:=ss; end;
              4:begin chkb8_5_1.Checked := s = '1';                              edt8_5_1.Text:=ss; end;
              5:begin chkb8_6_1.Checked := s = '1';                              edt8_6_1.Text:=ss; end;
              6:begin chkb8_7_1.Checked := s = '1';                              edt8_7_1.Text:=ss; end;
              7:begin chkb8_8_1.Checked := s = '1';                              edt8_8_1.Text:=ss; end;
              8:begin chkb8_9_1.Checked := s = '1';chkb8_9_2.Checked := s = '2'; edt8_9_1.Text:=ss; end;
              9:begin chkb8_10_1.Checked := s = '1';                             edt8_10_1.Text:=ss; end;
              10:begin chkb8_11_1.Checked := s = '1';                            edt8_11_1.Text:=ss; end;
              11:begin chkb8_12_1.Checked := s = '1';                            edt8_12_1.Text:=ss; end;
              12:begin chkb8_13_1.Checked := s = '1';                            edt8_13_1.Text:=ss; end;
              13:begin chkb8_14_1.Checked := s = '1';chkb8_14_2.Checked := s = '2';edt8_14_1.Text:=ss; end;
              14:begin chkb8_15_1.Checked := s = '1';                            edt8_15_1.Text:=ss; end;
              15:begin chkb8_16_1.Checked := s = '1';                            edt8_16_1.Text:=ss; end;
              16:begin chkb8_17_1.Checked := s = '1';                            edt8_17_1.Text:=ss; end;
              17:begin chkb8_18_1.Checked := s = '1';chkb8_18_2.Checked := s = '2';edt8_18_1.Text:=ss; end;
              18:begin chkb8_19_1.Checked := s = '1';chkb8_19_2.Checked := s = '2';edt8_19_1.Text:=ss; end;
              19:begin chkb8_20_1.Checked := s = '1';chkb8_20_2.Checked := s = '2';edt8_20_1.Text:=ss; end;
              20:begin chkb8_21_1.Checked := s = '1';chkb8_21_2.Checked := s = '2';edt8_21_1.Text:=ss; end;
              21:begin chkb8_22_1.Checked := s = '1';chkb8_22_2.Checked := s = '2';edt8_22_1.Text:=ss; end;
              22:begin chkb8_23_1.Checked := s = '1';chkb8_23_2.Checked := s = '2';edt8_23_1.Text:=ss; end;
              23:begin chkb8_24_1.Checked := s = '1';                            edt8_24_1.Text:=ss; end;
              24:begin chkb8_25_1.Checked := s = '1';                            edt8_25_1.Text:=ss; end;
              25:begin chkb8_26_1.Checked := s = '1';chkb8_26_2.Checked := s = '2';edt8_26_1.Text:=ss; end;
              26:begin chkb8_27_1.Checked := s = '1';                            edt8_27_1.Text:=ss; end;
            end;
          end;
        49:begin//TS1
            s := piece(sV,'^',3); chkb9_1_1.Checked:= s='1';chkb9_1_2.Checked:= s='0';chkb9_1_3.Checked:= s='9';
            s := piece(sV,'^',4); chkb9_2_1.Checked:= s='1';chkb9_2_2.Checked:= s='3';chkb9_2_3.Checked:= s='2';chkb9_2_4.Checked:= s='9';

            s := piece(sV,'^',5); chkb9_3_1.Checked:= s='1';chkb9_3_2.Checked:= s='0';chkb9_3_3.Checked:= s='9';

            s := piece(sV,'^',6); chkb9_4_1.Checked:= s='1';chkb9_4_2.Checked:= s='0';chkb9_4_3.Checked:= s='8';chkb9_4_4.Checked:= s='9';
            s := piece(sV,'^',7); chkb9_5_1.Checked:= s='1';chkb9_5_2.Checked:= s='0';chkb9_5_3.Checked:= s='9';
            s := piece(sV,'^',8); chkb9_6_1.Checked:= s='1';chkb9_6_2.Checked:= s='0';chkb9_6_3.Checked:= s='9';

            s := piece(sV,'^',9); chkb9_7_1.Checked:= s='1';chkb9_7_2.Checked:= s='2';chkb9_7_3.Checked:= s='3';chkb9_7_4.Checked:= s='9';
            s := piece(sV,'^',10); chkb9_8_1.Checked:= s='1';chkb9_8_2.Checked:= s='2';chkb9_8_3.Checked:= s='3';chkb9_8_4.Checked:= s='9';

            s := piece(sV,'^',11); chkb9_9_1.Checked:= s='1';chkb9_9_2.Checked:= s='2';chkb9_9_3.Checked:= s='3';chkb9_9_4.Checked:= s='4';chkb9_9_5.Checked:= s='7';chkb9_9_6.Checked:= s='9';

         end;
        53:begin//TS2
            s := piece(sV,'^',3); chkb9_10_1.Checked:= s='1';chkb9_10_2.Checked:= s='0';chkb9_10_3.Checked:= s='9';
            s := piece(sV,'^',4); chkb9_11_1.Checked:= s='1';chkb9_11_2.Checked:= s='0';chkb9_11_3.Checked:= s='9';
            s := piece(sV,'^',5); chkb9_12_1.Checked:= s='1';chkb9_12_2.Checked:= s='0';chkb9_12_3.Checked:= s='3';
            setDTP(dtp9_12_1, Piece(sV,'^',6));
            edt9_12_1.Text := piece(sV,'^',7);
//            edt9_12_2.Text := piece(sV,'^',7);//SOUNDEX
            edt9_12_3.Text := piece(sV,'^',8);//City
//            edt9_12_4.Text := piece(sV,'^',9);//State State??
            setComboBox(cmbb9_12_1, piece(sV,'^',9));
          end;
        57:begin//CM
          mmComments.Lines.Add(piece(sV,'^',3));
          end;
      end;
    end;
end;

procedure TFormCDC.FormDestroy(Sender: TObject);
begin
  TestCodes.Free;
  Operators.Free;
  States.Free;
  Params.Free;
  inherited;
end;

procedure TFormCDC.SetUpForm(aRegistry,aPatient:String;bReadOnly:Boolean;slData:TStrings);
begin
  PtIEN := aPatient;
  RegIEN := aRegistry;
  btnSubmit.Visible := not bReadOnly;
  SetFormStatus(not bReadOnly);
  ParamsLoad(slData);
end;

procedure TFormCDC.SetParamByNum(aKey,aValue: String;aPos,aMax: Integer;anOption:String);
var
  sTarget,
  s,ss: String;
  i,ii,iStart: Integer;
begin
  if aKey = '' then Exit;
  for i := 0 to mmParams.Lines.Count - 1 do
      if pos(aKey,mmParams.Lines[i])=1 then
        begin
          if aKey = 'AID' then
            begin
              sTarget := piece(mmParams.Lines[i],'^',2);
              if sTarget = anOption then
                break;
            end
          else
            break;
        end;
  if (mmParams.Lines.Count>0) and (i < mmParams.Lines.Count) then
    s := mmParams.Lines[i]
  else
    s := '';

  if aKey = 'AID' then
    begin
      if aValue = '' then
        begin
          if (i < mmParams.Lines.Count) and (aPos=3) then
            begin
              mmParams.Lines.Delete(i);
              exit;
            end;
        end;
      ss := aKey + '^'+anOption;
      iStart := 3
    end
  else
    begin
      ss := aKey;
      iStart := 2
    end;

  for ii := iStart to aMax do
    try
      if ii = aPos then
        ss := ss + '^' + aValue
      else
        ss := ss + '^' + piece(s,'^',ii);
    except
      ss := ss + '^';
    end;
  if i < mmParams.Lines.Count then
    mmParams.Lines[i] := ss
  else
    begin
      if (aKey = 'AID') and (piece(ss,'^',2)='') then
        exit;
      mmParams.Lines.Add(ss);
    end;
end;

procedure TFormCDC.acLoadParametersExecute(Sender: TObject);
begin
  ParamsLoad(mmParams.Lines);
end;

function TFormCDC.ParamLineGet(i:Integer): String;
begin
  try
    Result := {lvFields.Items[i].SubItems[iInternal] + }'^' +      //1
         {lvFields.Items[i].SubItems[iExternal] +} '^' +           //2
         lvFields.Items[i].SubItems[iXCoord] + '^' +             //3
         lvFields.Items[i].SubItems[iYCoord] + '^' +             //4
         lvFields.Items[i].SubItems[iFontSize] + '^' +           //5
         lvFields.Items[i].SubItems[iFormat] + '^' +             //6
         lvFields.Items[i].SubItems[iCharSpace] + '^' +          //7
         lvFields.Items[i].SubItems[iMaxChar] + '^' +            //8
         lvFields.Items[i].SubItems[iMaxWidth] + '^' +           //9
         lvFields.Items[i].SubItems[iMaxHeight] + '^' +          //10
         lvFields.Items[i].SubItems[iPage] + '^' +               //11
         lvFields.Items[i].SubItems[iKeyWord] + '^' +            //12
         lvFields.Items[i].SubItems[iPos] + '^' +                //13
         lvFields.Items[i].SubItems[iCode] + '^' +               //14
         lvFields.Items[i].SubItems[iMaxPos]+ '^'+               //15
         lvFields.Items[i].SubItems[iType]+'^'+                   //16
         lvFields.Items[i].SubItems[iComment];                    //17
  except
    Result := '';
  end;
end;

procedure TFormCDC.acSaveAsFileExecute(Sender: TObject);
var
  sL: TStringList;
  sValue,sName: String;
  i: Integer;
begin
  sL := TStringList.Create;
  for i := 0 to lvFields.Items.Count - 1 do
    begin
      {$IFDEF AANTEST}
        if i > iTestCount then Break;
      {$ENDIF}
      sName := ParamNameByNum(i);//'CDC'+IntToStr(i);
      sValue := ParamLineGet(i);
      sL.Add(sName + '='+sValue);
    end;
  sL.SaveToFile(sCDCListText);
  sL.Free;
end;

procedure TFormCDC.ParamLineSet(i: Integer;sValue:String);
var
  SS:String;
begin
  ss := sValue;

  lvFields.Items[i].SubItems[iInternal] := Piece(ss,'^',1);
  lvFields.Items[i].SubItems[iExternal] := Piece(ss,'^',2);
  lvFields.Items[i].SubItems[iXCoord] := Piece(ss,'^',3);
  lvFields.Items[i].SubItems[iYCoord] := Piece(ss,'^',4);

  if  Piece(ss,'^',5) <> '' then
    lvFields.Items[i].SubItems[iFontSize] := Piece(ss,'^',5)
  else
    lvFields.Items[i].SubItems[iFontSize] := IntToStr(idfFontSize);

  lvFields.Items[i].SubItems[iFormat] := Piece(ss,'^',6);

  if  Piece(ss,'^',7) <> '' then
    lvFields.Items[i].SubItems[iCharSpace] := Piece(ss,'^',7)
  else
    lvFields.Items[i].SubItems[iCharSpace] := IntToStr(idfCharSpace);

  lvFields.Items[i].SubItems[iMaxChar] := Piece(ss,'^',8);
  lvFields.Items[i].SubItems[iMaxWidth] := Piece(ss,'^',9);
  lvFields.Items[i].SubItems[iMaxHeight] := Piece(ss,'^',10);

  if  Piece(ss,'^',11) = '' then
    lvFields.Items[i].SubItems[iPage] := '1'
  else
    lvFields.Items[i].SubItems[iPage] := Piece(ss,'^',11);

  lvFields.Items[i].SubItems[iKeyword] := Piece(ss,'^',12);
  lvFields.Items[i].SubItems[iPos] := Piece(ss,'^',13);
  lvFields.Items[i].SubItems[iCode] := Piece(ss,'^',14);
  lvFields.Items[i].SubItems[iMaxPos] := Piece(ss,'^',15);

  lvFields.Items[i].SubItems[iType] := Piece(ss,'^',16);
  lvFields.Items[i].SubItems[iComment] := Piece(sValue,'^',17);

end;

procedure TFormCDC.ReAssignControls;
var
  aN: TTreeNode;
begin
  aN := tvOptions.Items.GetFirstNode;
  while aN <> nil do
    begin
      PanelControlsUpdate(TPanel(aN.Data));
      aN := aN.GetNext;
    end;
end;

procedure TFormCDC.acLoadFromFileExecute(Sender: TObject);
var
  sL: TStringList;
begin
  sL := TStringList.Create;
  sL.LoadFromFile(sCDCListText);
  ParamLoadFromList(sL);
  ReassignControls;
  sL.Free;
end;

procedure TFormCDC.acKillParamsExecute(Sender: TObject);
var
  sName:String;
  i: Integer;
begin
  if MessageDlg508('', 'Do you want to kill all parameter descriptions on server?'
    , mtConfirmation, [mbYes, mbNo], 0) = mrYes then
    begin
      Broker.CreateResults;
      for i := 0 to lvFields.Items.Count-1 do
        begin
          sName := ParamNameByNum(i);
          if not Broker.CallProc(rpcGUIParameterSet, [sName,'PKG','@']) then
            begin
              MessageDlg508('', 'Error deleting parameter <'+sName+'>',
                mtConfirmation, [mbYes, mbNo], 0);
              Break;
            end;
        end;
    end;
end;

function TFormCDC.ParamNameByNum(i:Integer): String;
begin
  Result := lvFields.Items[i].SubItems[iName];
end;

procedure TFormCDC.ParamLoadFromList(aL:TStrings);
var
  sName: String;
  sValue :String;
  i: INteger;
begin
  for i := 0 to lvFields.Items.Count - 1 do
    begin
      {$IFDEF AANTEST}
      if i > iTestCount then Break;
      {$ENDIF}
      try
        sName := ParamNameByNum(i);
         try
          sValue := aL.Values[sName];
          ParamLineSet(i,sValue);
          //-- Save row positions so we can fix transposed form and printout
          //-- answers. (Patch 17)
          if sName = 'chkb5_6_1' then
            CDCRowFix1 := IntVal(lvFields.Items[i].SubItems[iYCoord])
          else if sName = 'chkb5_5_1' then
            CDCRowFix2 := IntVal(lvFields.Items[i].SubItems[iYCoord]);
        except
          sValue := '';
        end;
      except
      end;
    end;
end;

procedure TFormCDC.DateFieldOnKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key >= ' ') and (Pos(Key, '0123456789/') = 0) then
    Key := #0;
end;

procedure TFormCDC.ZipFieldOnKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key >= ' ') and (Pos(Key, '0123456789-') = 0) then
    Key := #0;
end;

procedure TFormCDC.DateFieldOnExit(Sender: TObject);
var
  sM, sY, s: String;
  month, year: Integer;
begin
  s := Trim(TEdit(Sender).Text);
  if s <> '' then
    begin
      sM := Trim(Piece(s, '/', 1));
      sY := Trim(Piece(s, '/', 2));

      if sY = '' then
        begin
          sY := sM;
          sM := '';
        end;

      if sM <> '' then
        begin
          if Length(sM) < 2 then
            sM := '0' + sM;
          month := StrToIntDef(sM, -1);
          if (month < 1) or (month > 12) then
            begin
              ActiveControl := TEdit(Sender);
              Exit;
            end;
        end;

      case Length(sY) of
        1:
          sY := '0' + sY;
        2:;
        4:
          if sM <> '' then
            sY := AnsiRightStr(sY, 2);
        else
          begin
            ActiveControl := TEdit(Sender);
            Exit;
          end;
      end;

      year := StrToIntDef(sY, -1);
      if (year < 0) or (year > 9999) then
        begin
          ActiveControl := TEdit(Sender);
          Exit;
        end;

      with TEdit(Sender) do
        if sM <> '' then
          Text := sM  + '/' + sY
        else
          Text := sY;
    end;
end;

procedure TFormCDC.PanelControlsSet(aPnl:TPanel;var iNum: Integer; var aC:String);
var
  j: Integer;
  s: String;

  procedure AddControl(aTypeName:String;aControl:TControl);
  var
    li: TListItem;

    function ControlIntValue(aC:TControl):String;
    begin
      if aC is TEdit then
        Result := TEdit(aC).Text
      else if aC is TComboBox then
        Result := TComboBox(aC).Text
      else if aC is TDateTimePicker then
        Result := DateToStr(TDateTimePicker(aC).Date)
      else
        Result := 'Unknown'
    end;

    function ControlExtValue(aC:TControl):String;
    begin
      Result := '';
    end;

  begin
    li := lvFields.Items.Add;
    li.Caption := IntToStr(iNum);

    li.SubItems.Add(aTypeName);
    li.SubItems.Add(aControl.Name);// GUI Name
    li.SubItems.Add(ControlIntValue(aControl));// Value Int
    li.SubItems.Add(ControlIntValue(aControl));// Value Ext

    if aControl.Visible then   // Visible
      li.SubItems.Add('1')
    else
      li.SubItems.Add('0');

    li.SubItems.Add('');// X
    li.SubItems.Add('');// Y
    li.SubItems.Add('');// FontSize
    li.SubItems.Add('');// Format
    li.SubItems.Add('');// CharSpace
    li.SubItems.Add('');// MaxChar
    li.SubItems.Add('');// MaxWidth
    li.SubItems.Add('');// MaxHeight
    li.SubItems.Add('');// Page
    li.SubItems.Add('');//Group Kyeword
    li.SubItems.Add('');//Position
    li.SubItems.Add('');//Code
    li.SubItems.Add('');//MaxPos
    li.SubItems.Add('');//Comments

    aControl.Tag := iNum; // for later navigation

    inc(iNum);
  end;

  procedure AssignCombo(aC:TControl);
  var
    i: Integer;
  begin
    AddControl('TComboBox',aC);
    if not Assigned(TComboBox(aC).OnChange) then
      TComboBox(aC).OnChange := ProcessComboBox;
    for i := 0 to TComboBox(aC).Items.Count - 1 do
      if TComboBox(aC).Items[i] = 'Unknown' then
        TComboBox(aC).ItemIndex := i;

    lvFields.Items[aC.Tag].StateIndex := stDefault;
  end;

  procedure AssignEdit(aC:TControl);
  begin
    AddControl('TEdit',aC);
    if not Assigned(TEdit(aC).OnChange) then
      TEdit(aC).OnChange := ProcessEdit;
    TEdit(aC).Text := '';
    lvFields.Items[aC.Tag].StateIndex := stDefault;
  end;

  procedure AssignChkb(aC:TControl);
  begin
    AddControl('TCheckBox',aC);
    try
      TCheckBox(aC).Checked := False;
    except
    end;
    if not Assigned(TCheckBox(aC).OnClick) then
      TCheckBox(aC).OnClick := ProcessCheckBox;
    if not Assigned(TCheckBox(aC).OnEnter) then
      TCheckBox(aC).OnEnter := ChkbEnter;
    if not Assigned(TCheckBox(aC).OnExit) then
      TCheckBox(aC).OnExit := ChkbExit;

    lvFields.Items[aC.Tag].StateIndex := stDefault;
  end;

  procedure AssignDTP(aC:TControl);
  begin
    AddControl('TDateTImePicker',aC);
    if not Assigned(TEdit(aC).OnChange) then
      TEdit(aC).OnChange := DTPChange;
    TDateTimePicker(aC).Date := Now;
    TDateTimePicker(aC).MaxDate := Now;
    lvFields.Items[aC.Tag].StateIndex := stDefault;
  end;

  procedure AssignGroupBox(aC:TGroupBox);
  var
    ii: Integer;
  begin
    for ii := 0 to aC.ControlCount - 1 do
      begin
        if aC.Controls[ii] is TEdit then
            AssignEdit(aC.Controls[ii])
        else if aC.Controls[ii] is TCheckBox then
            AssignChkb(aC.Controls[ii])
        else if aC.Controls[ii] is TComboBox then
            AssignCombo(aC.Controls[ii])
        else if aC.Controls[ii] is TDateTimePicker then
            AssignDTP(aC.Controls[ii]);
      end;
  end;

begin
  for j := 0 to aPnl.ControlCount - 1 do
    begin
      if (aPnl.Controls[j] is TPanel) and
        (TLabel(aPnl.Controls[j]).Tag <> 0) then
          begin
            s := TPanel(aPnl.Controls[j]).Caption;
            while pos(' ',s) = 1 do s := copy(s,2,length(s)-1);
            aC := s;
          end
      else if aPnl.Controls[j] is TGroupBox then
          AssignGroupBox(TGroupBox(aPnl.Controls[j]))
      else if aPnl.Controls[j] is TEdit then
          AddControl('TEdit',aPnl.Controls[j])
      else if aPnl.Controls[j] is TCheckBox then
          AddControl('TCheckBox',aPnl.Controls[j])
      else if aPnl.Controls[j] is TComboBox then
          AddControl('TComboBox',aPnl.Controls[j])
      else if aPnl.Controls[j] is TDateTimePicker then
          AddControl('TDateTImePicker',aPnl.Controls[j])
      else if aPnl.Controls[j] is TMemo then
          AddControl('TMemo',aPnl.Controls[j]);
    end;
end;

procedure TFormCDC.PanelControlsUpdate(aPnl:TPanel);
var
  i,j: Integer;
  s: String;

  procedure AssignCombo(aC:TControl);
  var
    i: Integer;
  begin
    TComboBox(aC).OnChange := ProcessComboBox;

    for i := 0 to TComboBox(aC).Items.Count - 1 do
      if TComboBox(aC).Items[i] = 'Unknown' then
        TComboBox(aC).ItemIndex := i;

    lvFields.Items[aC.Tag].StateIndex := stDefault;
  end;

  procedure AssignChkb(aC:TControl);
  begin
    try
      TCheckBox(aC).Checked := False;
    except
    end;
    TCheckBox(aC).OnClick := ProcessCheckBox;
    TCheckBox(aC).OnEnter := ChkbEnter;
    TCheckBox(aC).OnExit := ChkbExit;

    lvFields.Items[aC.Tag].StateIndex := stDefault;
  end;

  procedure AssignDTP(aC:TControl);
  begin
    TDateTimePicker(aC).OnChange := DTPChange;
    TDateTimePicker(aC).Date := Now;
    TDateTimePicker(aC).MaxDate := Now;
    lvFields.Items[aC.Tag].StateIndex := stDefault;
  end;

  procedure AssignMemo(aC:TControl);
  begin
  end;

  procedure AssignEdit(aC:TControl;aKey:String);
  begin
    if aKey = 'MM/YY' then
      begin
        TEdit(aC).OnKeyPress := DateFieldOnKeyPress;
        TEdit(aC).OnExit := DateFieldOnExit;
      end
    else if aKey = 'ZIP' then
      begin
        TEdit(aC).OnKeyPress := ZIPFieldOnKeyPress;
        TEdit(aC).OnExit := nil;
      end
    else
      begin
        TEdit(aC).OnKeyPress := nil;
        TEdit(aC).OnExit := nil;
      end;
    TEdit(aC).OnChange := ProcessEdit;

    TEdit(aC).Text := '';
    lvFields.Items[aC.Tag].StateIndex := stDefault;
  end;

  procedure AssignGroupBox(aC:TGroupBox);
  var
    i: Integer;
    ii: Integer;
  begin
    for ii := 0 to aC.ControlCount - 1 do
      begin
        if aC.Controls[ii] is TEdit then
          begin
            i := TEdit(aC.Controls[ii]).Tag;
            AssignEdit(aC.Controls[ii],lvFields.Items[i].SubItems[iType]);
          end
        else if aC.Controls[ii] is TCheckBox then
            AssignChkb(aC.Controls[ii])
        else if aC.Controls[ii] is TComboBox then
            AssignCombo(aC.Controls[ii])
        else if aC.Controls[ii] is TDateTimePicker then
            AssignDTP(aC.Controls[ii]);
      end;
  end;

begin
  for j := 0 to aPnl.ControlCount - 1 do
    begin
      if aPnl.Controls[j] is TGroupBox then
          AssignGroupBox(TGroupBox(aPnl.Controls[j]))
      else if aPnl.Controls[j] is TEdit then
        begin
          i := TEdit(aPnl.Controls[j]).Tag;
          s := lvFields.Items[i].SubItems[iType];
          AssignEdit(aPnl.Controls[j],s);
        end
      else if aPnl.Controls[j] is TCheckBox then
          AssignChkb(aPnl.Controls[j])
      else if aPnl.Controls[j] is TComboBox then
          AssignCombo(aPnl.Controls[j])
      else if aPnl.Controls[j] is TDateTimePicker then
          AssignDTP(aPnl.Controls[j])
      else if aPnl.Controls[j] is TMemo then
          AssignMemo(aPnl.Controls[j]);
    end;
end;

procedure TFormCDC.pcCDCChange(Sender: TObject);
begin
  acZoomToFit.Enabled := pcCDC.ActivePage <> tsForm;
  acZoomIn.Enabled := pcCDC.ActivePage <> tsForm;
  acZoomOut.Enabled := pcCDC.ActivePage <> tsForm;
  acZoomOne.Enabled := pcCDC.ActivePage <> tsForm;
  chkbAutoZoom.Enabled := pcCDC.ActivePage <> tsForm;
  if pcCDC.ActivePage <> tsForm then
      DrawItems(False);
  FormResize(Self);
end;

procedure TFormCDC.Button1Click(Sender: TObject);
var
  i: Integer;
begin
  if dlgVUSelector.ShowModal = mrOK then
    try
      i := edt7_1.Tag;
      edt7_1.Text := dlgVUSelector.lvVUsers.Selected.SubItems[0];
      lvFields.Items[i].SubItems[iInternal] :=dlgVUSelector.lvVUsers.Selected.Caption;
      edt7_3.Text := dlgVUSelector.lvVUsers.Selected.SubItems[1];
      edt7_4.Text := dlgVUSelector.lvVUsers.Selected.SubItems[3];//Hospital
    except
    end;
end;

procedure TFormCDC.FormResize(Sender: TObject);
begin
  if chkbAutoZoom.Checked then
    acZoomToFitExecute(Self);
end;

procedure TFormCDC.dtp2_1Change(Sender: TObject);
var
  i: Integer;
begin
  i := TDateTimePicker(Sender).Tag;
  if chkb9_12_1.Checked then
    begin
      lvFields.Items[i].SubItems[iInternal] := DateToStr(TDateTimePicker(Sender).Date);
      lvFields.Items[i].SubItems[iExternal] := DateToStr(TDateTimePicker(Sender).Date);
    end
  else
    begin
      lvFields.Items[i].SubItems[iInternal] := '';
      lvFields.Items[i].SubItems[iExternal] := '';
    end;
  lvFields.Items[i].StateIndex := stChanged;
  SetParamByNum(
    lvFields.Items[i].SubItems[iKeyWord],
    lvFields.Items[i].SubItems[iInternal],
    intVal(lvFields.Items[i].SubItems[iPos]),
    intVal(lvFields.Items[i].SubItems[iMaxPos]),
    lvFields.Items[i].SubItems[iMaxHeight]//Sorry it will contain an option
  );
end;

procedure TFormCDC.acZoomOneExecute(Sender: TObject);
begin
  fscale := 1.0;
  imgPreview.Width := 2550;
  imgPreview.Height := 3300;
  imgPreview2.Width := 2550;
  imgPreview2.Height := 3300;
end;

procedure TFormCDC.acSubmitExecute(Sender: TObject);
var
  i, ip: Integer;
  s1,s2:String;
  aSL:TStringList;
  errCtrl: TWinControl;

  procedure SetAControl(aControl:TWinControl;aMsg:String);
  begin
    MessageDlg508('', 'Errors saving CDC data'+#13+#13+'Check '+aMsg+#13, mtError,[mbOK],0);
    ActiveControl := aControl;
  end;

begin
//      ShowMessage(frmCDCList.mmParams.Text);
      aSL := TStringList.Create;
      aSL.Assign(mmParams.Lines);
      if Broker.CallProc(rpcCDCSave, [RegIEN,PtIEN,''], aSL) then
        begin
          s1 := Piece(Broker.Results[0],'^',1);
          s2 := Piece(Broker.Results[0],'^',2);
          ip := StrToIntDef(s1, 0);
          if ip > 0 then
            begin
                   // 1   5   9   13  17  21  25  29  33  37  41  45  49  53  57
//  sParamKeywords = 'DEM ADR RCE ETN HDR CDM FD  PH  LD1 LD2 CS  AID TS1 TS2 CMT ';
              i := pos(trim(s2),sParamKeywords);
              Case i of
                 1: ;
                 5: ;
                 9: ;
                13: ;
                17: ;
                21:
                  begin
                    errCtrl := edt3_1_1;
                    case ip of
                       4: begin
                            if edt3_1_2.Enabled then
                              errCtrl := edt3_1_2;
                            if edt3_1_1.Enabled then
                              errCtrl := edt3_1_1;
                          end;
                       8: begin
                            if edt3_7_2.Enabled then
                              errCtrl := edt3_7_2;
                            if edt3_7_1.Enabled then
                              errCtrl := edt3_7_1;
                          end;
                       9: errCtrl := edt3_8_1;
                      10: errCtrl := edt3_8_2;
                      11,
                      12: errCtrl := cmbb3_8_1;
                      13: errCtrl := edt3_8_5;
                      14: errCtrl := edt3_8_4;
                    end;
                    SetAControl(errCtrl, 'CDC demographic data');
                  end;
                25:
                  begin
                    errCtrl := edt4_1_1;
                    case ip of
                       3: errCtrl := edt4_1_1;
                       4: errCtrl := edt4_1_2;
                       5,
                       6: errCtrl := cmbb4_1_1;
                       7: errCtrl := edt4_1_4;
                      10: errCtrl := edt4_3_1;
                    end;
                    SetAControl(errCtrl, 'Facility of diagnostic data');
                  end;
                29:
                  SetAControl(chkb5_1_1, 'Patient History data');
                33:
                  begin
                    errCtrl := chkb6_1_1;
                    case ip of
                       4: errCtrl := edt6_1_1;
                       6: errCtrl := edt6_2_1;
                       8: errCtrl := edt6_3_1;
                      10: errCtrl := edt6_4_1;
                      11: errCtrl := edt6_4_2;
                      13: errCtrl := edt6_5_1;
                      14: errCtrl := edt6_5_2;
                      15: errCtrl := edt6_5_3;
                      17: errCtrl := edt6_6_1;
                      18: errCtrl := edt6_6_2;
                    end;
                    SetAControl(errCtrl, 'Laboratory data');
                  end;
                37:
                  begin
                    errCtrl := edt6_7_1;
                    case ip of
                       3: errCtrl := edt6_7_2;
                       4: errCtrl := edt6_7_1;
                       6: errCtrl := edt6_8_1;
                       7: errCtrl := edt6_9_1;
                       8: errCtrl := edt6_9_2;
                       9: errCtrl := edt6_9_3;
                      10: errCtrl := edt6_9_4;
                      11: errCtrl := edt6_9_5;
                      12: errCtrl := edt6_9_6;
                      13: errCtrl := edt6_9_7;
                      14: errCtrl := edt6_9_8;
                    end;
                    SetAControl(errCtrl, 'Laboratory data');
                  end;
                41:
                  begin
                    errCtrl := chkb8_1;
                    case ip of
                       4: errCtrl := edt8_1_1;
                       5: errCtrl := edt8_1_2;
                       6: errCtrl := edt8_1;
                    end;
                    SetAControl(errCtrl, 'Clinical Status');
                  end;
                45:
                  SetAControl(chkb8_2_1, 'CLinical Status');
                49:
                  SetAControl(chkb9_1_1, 'Treatment/Services data');
                53:
                  begin
                    errCtrl := chkb9_10_1;
                    case ip of
                      7: errCtrl := edt9_12_1;
                      8: errCtrl := edt9_12_3;
                    end;
                    SetAControl(errCtrl, 'Treatment/Services data');
                  end;
                57:
                  SetAControl(mmComments, 'Comments');
              end;
              ModalResult := mrNone;
            end
          else
            ModalResult := mrOK;
        end
      else
        MessageDlg508('', RSC00260, mtError, [mbOK], 0);
      aSL.Free;
end;

procedure TFormCDC.UpdateImageScale(aScale:Double);
begin
  imgPreview.Width := Round(imgPreview.Width *aScale);
  imgPreview.Height := Round(imgPreview.Height *aScale);
  imgPreview2.Width := Round(imgPreview2.Width *aScale);
  imgPreview2.Height := Round(imgPreview2.Height *aScale);
  fScale := fScale / aScale;
end;

procedure TFormCDC.acZoomToFitExecute(Sender: TObject);
var
  ff: Double;
begin
  ff := scbPreview.Width / imgPreview.Width;
  UpdateImageScale(ff);
end;

procedure TFormCDC.acZoomInExecute(Sender: TObject);
begin
  UpdateImageScale(1.2);
end;

procedure TFormCDC.acZoomOutExecute(Sender: TObject);
begin
  UPdateImageScale(1/1.2);
end;

procedure TFormCDC.FormActivate(Sender: TObject);
begin
 try
   fdlg.Font.Size := iCDCFontSize;

   RefreshColors;

   edtPage1.Text := CCROptions.CDC1Bmp;
   edtPage2.Text := CCROptions.CDC2Bmp;

  if pcCDC.ActivePage = tsBitmap then
    imgPreview.Invalidate;
  if pcCDC.ActivePage = tsPage2 then
    imgPreview2.Invalidate;
  if pcCDC.ActivePage <> tsForm then
    DrawItems(False);

  if CCRScreenReaderActive then
    Section508Fixes;

 except
 end;
end;

//-- Section 508: Fix screen elements if a screen reader is being used
procedure TFormCDC.Section508Fixes;
var i: integer;
begin
  //-- Display a warning regarding disabled controls.
  MessageDlg508('', RSC50801, mtWarning, [mbOK], 0);

  //-- Enable tab stops so the screen reader will recognize fields
  for i := 0 to ComponentCount - 1 do
  begin
    if (Components[i].Tag = 508) then
    begin
      TControl(Components[i]).Enabled := true;
      TControl(Components[i]).Visible := true;
      if (Components[i] is TStaticText) then
        TStaticText(Components[i]).TabStop := true;
    end;
    if (Components[i] is TPanel) and (Components[i].Tag = 10) then
    begin
      with TPanel(Components[i]) do
        TabStop := true;
    end;
  end;

  //-- Clean up various panels
  with pnlCDC21_I do           //"STATE/LOCAL USE ONLY" panel
  begin
    for i := 0 to ControlCount - 1 do
    begin
      if (Controls[i] is TEdit) then
      begin
        with TEdit(Controls[i]) do
        begin
          Enabled := true;
          TabStop := true;
        end;
      end;
    end;
  end;
  dtp2_1.Left := stxtDateCompleted.Left + stxtDateCompleted.Width + 15;
  with pnlCDC21_V do           //"Patient History" panel
  begin
    for i := 0 to ControlCount - 1 do
    begin
      if (Controls[i].Name <> 'Panel32') then
        Controls[i].Enabled := false;
    end;
  end;
  if chkb3_4_1.Checked then   //Male so disable "FOR WOMEN:" section
  begin
    StaticText142.Enabled := false;
    StaticText144.Enabled := false;
    StaticText145.Enabled := false;
    StaticText146.Enabled := false;
    stxt9_12_1.Enabled := false;
  end;
  Panel3.SetFocus;
end;

procedure TFormCDC.RefreshColors;
var
  aN: TTreeNode;
begin
  aN := tvOptions.Items.GetFirstNode;
  while aN <> nil do
    begin
      PanelControlsRefreshColors(TPanel(aN.Data));
      aN := aN.GetNext;
    end;
end;

procedure TFormCDC.PanelControlsRefreshColors(aPnl:TPanel);
var
  j: Integer;
  clReadOnly: TColor;

  procedure AssignGroupBox(aC:TGroupBox);
  var
    ii: Integer;
  begin
    for ii := 0 to aC.ControlCount - 1 do
        if aC.Controls[ii] is TEdit then
          begin
            if TEdit(aC.Controls[ii]).ReadOnly then
              TEdit(aC.Controls[ii]).Color := clReadOnly
            else if not TEdit(aC.Controls[ii]).Enabled then
              TEdit(aC.Controls[ii]).Color := clBtnFace;
          end
        else if aC.Controls[ii] is TComboBox then
          begin
            if not TComboBox(aC.Controls[ii]).Enabled
              or not aC.Enabled then
              TComboBox(aC.Controls[ii]).Color := clBtnFace;
          end
        else if aC.Controls[ii] is TDateTimePicker then
          begin
            if not TDateTimePicker(aC.Controls[ii]).Enabled then
              TDateTimePicker(aC.Controls[ii]).Color := clBtnFace;
          end
        else if aC.Controls[ii] is TMemo then
          begin
            if TMemo(aC.Controls[ii]).ReadOnly then
              TMemo(aC.Controls[ii]).Color := clReadOnly;
          end;
  end;

begin
  clReadOnly := CCROptions.IE[ieReadOnly].Color;
  for j := 0 to aPnl.ControlCount - 1 do
    begin
        if aPnl.Controls[j] is TGroupBox then
            AssignGroupBox(TGroupBox(aPnl.Controls[j]))
        else if aPnl.Controls[j] is TEdit then
          begin
            if TEdit(aPnl.Controls[j]).ReadOnly then
              TEdit(aPnl.Controls[j]).Color := clreadOnly
            else if not TEdit(aPnl.Controls[j]).Enabled or not aPnl.Enabled then
              TEdit(aPnl.Controls[j]).Color := clBtnFace;
          end
        else if aPnl.Controls[j] is TComboBox then
          begin
            if not TComboBox(aPnl.Controls[j]).Enabled
              or not aPnl.Enabled  or not aPnl.Enabled then
              TComboBox(aPnl.Controls[j]).Color := clBtnFace;
          end
        else if aPnl.Controls[j] is TDateTimePicker then
          begin
            if not TDateTimePicker(aPnl.Controls[j]).Enabled  or not aPnl.Enabled then
              TDateTimePicker(aPnl.Controls[j]).Color := clBtnFace;
          end
        else if aPnl.Controls[j] is TMemo then
            if TMemo(aPnl.Controls[j]).ReadOnly then
              TMemo(aPnl.Controls[j]).Color := clReadOnly
            else if not aPnl.Enabled then
              TMemo(aPnl.Controls[j]).Color := clBtnFace;
    end;
end;

procedure TFormCDC.SetFormStatus(aStatus:Boolean);
begin
  pnlCDC21_I.Enabled := aStatus;
  pnlCDC21_II.Enabled := aStatus;
  pnlCDC21_III.Enabled := aStatus;
  pnlCDC21_IV.Enabled := aStatus;
  pnlCDC21_V.Enabled := aStatus;
  pnlCDC21_VI.Enabled := aStatus;
  pnlCDC21_VII.Enabled := aStatus;
  pnlCDC21_VIII.Enabled := aStatus;
  pnlCDC21_IX.Enabled := aStatus;
  pnlCDC21_X.Enabled := aStatus;
  acSubmit.Enabled := aStatus;
end;

procedure TFormCDC.CleanUpFields(aPnl:TPanel);
var
  j: Integer;

  procedure AssignGroupBox(aC:TGroupBox);
  var
    ii: Integer;
  begin
    for ii := 0 to aC.ControlCount - 1 do
        if aC.Controls[ii] is TEdit then
          begin
            TEdit(aC.Controls[ii]).Text := '';
          end
        else if aC.Controls[ii] is TComboBox then
          with TComboBox(aC.Controls[ii]) do
            begin
              ItemIndex := 0;
              Text := '';
              lvFields.Items[Tag].SubItems[iInternal] := '';
              lvFields.Items[Tag].SubItems[iExternal] := '';
            end
        else if aC.Controls[ii] is TDateTimePicker then
          begin
            TDateTimePicker(aC.Controls[ii]).Date := Now;
          end
        else if aC.Controls[ii] is TMemo then
          begin
              TMemo(aC.Controls[ii]).Text := '';
          end
        else if aC.Controls[ii] is TCheckBox then
          begin
              TCheckBox(aC.Controls[ii]).Checked := False;
          end;
  end;

begin
  for j := 0 to aPnl.ControlCount - 1 do
    begin
        if aPnl.Controls[j] is TGroupBox then
            AssignGroupBox(TGroupBox(aPnl.Controls[j]))
        else if aPnl.Controls[j] is TEdit then
          begin
            TEdit(aPnl.Controls[j]).Text := '';
          end
        else if aPnl.Controls[j] is TComboBox then
          with TComboBox(aPnl.Controls[j]) do
            begin
              ItemIndex := 0;
              Text := '';
              lvFields.Items[Tag].SubItems[iInternal] := '';
              lvFields.Items[Tag].SubItems[iExternal] := '';
            end
        else if aPnl.Controls[j] is TDateTimePicker then
            begin
              TDateTimePicker(aPnl.Controls[j]).Date := Now;
            end
        else if aPnl.Controls[j] is TMemo then
          begin
              TMemo(aPnl.Controls[j]).Text := '';
          end
        else if aPnl.Controls[j] is TCheckBox then
          begin
              TCheckBox(aPnl.Controls[j]).Checked := False;
          end;
    end;
end;

procedure TFormCDC.RefreshPanels;
var
  aN: TTreeNode;
begin
  aN := tvOptions.Items.GetFirstNode;
  while aN <> nil do
    begin
      CleanUpFields(TPanel(aN.Data));
      aN := aN.GetNext;
    end;
end;

procedure TFormCDC.SaveLayout;
var
  sL: TStringList;

  procedure AddParam(aName,aValue:String);
  begin
    sL.Add(aName + '='+aValue);
  end;

begin
  sL := TStringList.Create;
  sL.Add('');

  AddParam(sCDCIndex,IntToStr(pcCDC.ActivePageIndex));
  AddParam(sCDCTree, IntToStr(pnlTree.Width));
  if pnlTree.Visible then
    AddParam(sCDCNavigator,'1')
  else
    AddParam(sCDCNavigator,'0');

  if not Broker.CallProc(rpcGUIParameterSet, [sCDCLayout,'USR'], sL) then
      MessageDlg508('', 'Errors saving CDC layout',mtError,[mbOK],0);

  sL.Free;
end;

procedure TFormCDC.LoadLayout;
var
  ss:String;
  sL: TStringList;
begin
  if Broker.CallProc(rpcGUIParameterGet, [sCDCLayout,'USR']) then
    if Broker.Results.Count > 1 then
      begin
        sL := TStringList.Create;
        sL.Assign(Broker.Results);
        try
          ss := sL.Values[sCDCIndex];
          pcCDC.ActivePage := pcCDC.Pages[StrToIntDef(ss,0)];

          pnlTree.Width := StrToIntDef(sL.Values[sCDCTree],100);
          pnlTree.Visible := sL.Values[sCDCNavigator] = '1';
        except
        end;
        sL.Free;
      end;
end;

procedure TFormCDC.FormDeactivate(Sender: TObject);
begin
  SaveLayout;
end;

procedure TFormCDC.acPrintBlankExecute(Sender: TObject);
begin
  PrintCDCForm(True);
end;

end.

